/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class ANSCHUTZ_STD20_Decoder
extends Decoder {
    private final Encoder Encod;

    public ANSCHUTZ_STD20_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 2;
        int Length_Blk = 18;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Heading(\u00b0)" + sep + "HeadingRate(\u00b0/s)" + sep + "Status a" + sep + "Status b" + sep + "Status fg";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        String sep = this.Info.GetSeparator();
        if (Detected_Frame[0] != 2) {
            return -1;
        }
        for (int i = 3; i < 8; ++i) {
            if (Detected_Frame[i] == 64) continue;
            return -1;
        }
        if (Detected_Frame[13] != 64) {
            return -1;
        }
        if (Detected_Frame[14] != 64) {
            return -1;
        }
        if (Detected_Frame[15] != 64 && Detected_Frame[15] != 67) {
            return -1;
        }
        if (Detected_Frame[17] != 3) {
            return -1;
        }
        int Heading_Bin = Detected_Frame[1] % 64 * 1024 + Detected_Frame[2] % 64 * 16;
        float Heading = (float)(0.00549 * (double)Heading_Bin);
        int Heading_Rate_Bin = Detected_Frame[8] % 8 * 4096 + Detected_Frame[9] % 64 * 64 + Detected_Frame[10] % 64;
        if (Detected_Frame[8] % 64 >= 32) {
            Heading_Rate_Bin -= 32768;
        }
        float Heading_Rate = (float)(0.08046 * (double)Heading_Rate_Bin);
        Heading_Rate = -((float)((double)Heading_Rate / 60.0));
        int Status_a = Detected_Frame[11] % 64 / 32;
        int Status_b = Detected_Frame[11] % 32 / 16;
        int Status_f = Detected_Frame[11] % 2;
        int Status_g = Detected_Frame[12] % 64 / 32;
        this.InterpretedFrame = this.InterpretFloat(Heading, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heading_Rate, 110);
        this.InterpretedFrame = this.InterpretedFrame + "a(PHINS only)=";
        this.InterpretedFrame = this.InterpretedFrame + (Status_a > 0 ? "1" : "0");
        this.InterpretedFrame = this.InterpretedFrame + sep;
        this.InterpretedFrame = this.InterpretedFrame + "b=";
        this.InterpretedFrame = this.InterpretedFrame + (Status_b > 0 ? "1" : "0");
        this.InterpretedFrame = this.InterpretedFrame + sep;
        this.InterpretedFrame = this.InterpretedFrame + "fg=";
        this.InterpretedFrame = this.InterpretedFrame + (Status_f > 0 ? "1" : "0");
        this.InterpretedFrame = this.InterpretedFrame + (Status_g > 0 ? "1" : "0");
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

