/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class ATLAS_F20_decoder
extends Decoder {
    private final Encoder Encod;

    public ATLAS_F20_decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 16;
        int Length_Blk = 9;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Heave(m)" + sep + "Status";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        double _Roll = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 1, 1) / 65536.0 * 360.0;
        double _Pitch = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 3, 1) / 65536.0 * 360.0;
        double _Heave = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 5, 1);
        byte _Status = this.Bytes_Frame[7];
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(148, _Heave, 12);
            this.Encod.setValue(104, _Roll, 1);
            this.Encod.setValue(105, _Pitch, 1);
            this.Encod.setValue(1003, Integer.valueOf(_Status), 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretDouble(_Roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(_Pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(_Heave / 1000.0, 148);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(_Status);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

