/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class DCN_FAA_Decoder
extends Decoder {
    private Encoder Encod;

    public DCN_FAA_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 0;
        Start_Blk[1] = 34;
        int Length_Blk = 34;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "INSId" + sep + "Status" + sep + "Heading(\u00b0)" + sep + "HeadingRate(\u00b0/s)" + sep + "Roll(\u00b0)" + sep + "RollRate(\u00b0/s)" + sep + "Pitch(\u00b0)" + sep + "PitchRate(\u00b0/s)" + sep + "LochSpeed((m/s)" + sep + "Ageing(s)" + sep + "Lat(\u00b0)" + sep + "Long(\u00b0)" + sep + "NorthSpeed(m/s)" + sep + "WestSpeed(mm/s)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        int MSGLen = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 0, 1);
        if (MSGLen != 34) {
            return -1;
        }
        int INSid = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 2, 1);
        int StatusMSB = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 4, 1);
        int StatusLSB = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 5, 1);
        if (StatusMSB != 0) {
            return -1;
        }
        double Heading = (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 6, 1) * 180.0 / 8388608.0;
        double HeadingRate = (double)this.Convert_1Byte_to_SignedInt(Detected_Frame, 9, 1) * 70.32 / 128.0;
        double Roll = (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 10, 1) * 90.0 / 8388608.0;
        double RollRate = (double)this.Convert_1Byte_to_SignedInt(Detected_Frame, 13, 1) * 35.16 / 128.0;
        double Pitch = (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 14, 1) * 90.0 / 8388608.0;
        double PitchRate = (double)this.Convert_1Byte_to_SignedInt(Detected_Frame, 17, 1) * 35.16 / 128.0;
        double LochSpeed = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 18, 1) * 0.003662109375 * 0.5144444444444445;
        double Age = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 20, 1) * 1.28 / 32768.0;
        double Lat = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 22, 1) * 90.0 / 2.147483648E9;
        double Long2 = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 26, 1) * 180.0 / 2.147483648E9;
        double NorthVel = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 30, 1) * 0.003662109375 * 0.5144444444444445;
        double WestVel = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 32, 1) * 0.003662109375 * 0.5144444444444445;
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(1000, StatusLSB, 1000);
            this.Encod.setValue(103, Heading, 1);
            this.Encod.setValue(110, HeadingRate, 51);
            this.Encod.setValue(104, -Roll, 1);
            this.Encod.setValue(111, -RollRate, 51);
            this.Encod.setValue(105, Pitch, 1);
            this.Encod.setValue(112, PitchRate, 51);
            this.Encod.setValue(241, LochSpeed, 21);
            this.Encod.setValue(707, Age, 32);
            this.Encod.setValue(124, Lat, 1);
            Long2 = 360.0 - Long2;
            this.Encod.setValue(125, Long2, 1);
            this.Encod.setValue(136, NorthVel, 21);
            this.Encod.setValue(137, -WestVel, 21);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretIntegerAsInt(INSid);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsBin(StatusLSB);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(HeadingRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(RollRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(PitchRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LochSpeed);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Age);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(NorthVel);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(WestVel);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

