/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class DCN_STD_NAV1_Decoder
extends Decoder {
    private Encoder Encod;

    public DCN_STD_NAV1_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk_n1 = new byte[Start_Blk_Length];
        byte[] Start_Blk_n2 = new byte[Start_Blk_Length];
        Start_Blk_n1[0] = 27;
        Start_Blk_n2[0] = 40;
        int Length_Blk_n1 = 27;
        int Length_Blk_n2 = 40;
        this.DecodeInit(0, Length_Blk_n1, Start_Blk_n1, Start_Blk_Length);
        this.DecodeInit(0, Length_Blk_n2, Start_Blk_n2, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Status1" + sep + "Status2" + sep + "Hour(h)" + sep + "Ageing(ms)" + sep + "Heading(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Lat(\u00b0)" + sep + "Long(\u00b0)" + sep + "NorthSpeed(knots)" + sep + "WestSpeed(knots)" + sep + "Date" + sep + "Heave(m)" + sep + "EMLogSpeed(knots)" + sep + "VerticalSpeed(knots)" + sep + "LatStd(NM)" + sep + "LongStd(NM)" + sep + "HeadingStd(\u00b0)" + sep + "PosErr(NM)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        int Status1 = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 1, 1);
        int Status2 = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 2, 1);
        double Hour = (double)(this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 3, 1) * 12L) / 2.147483648E9;
        int Ageing = this.Convert_1Byte_to_SignedInt(Detected_Frame, 7, 1);
        if (Ageing != 4) {
            this.InterpretedFrame = this.InterpretString("Ageing field error");
            this.InterpretedFrame_AddToList(this.InterpretedFrame);
            return -1;
        }
        double Heading = (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 8, 1) * 180.0 / 8388608.0;
        double Roll = (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 11, 1) * 90.0 / 8388608.0;
        double Pitch = (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 14, 1) * 90.0 / 8388608.0;
        double Lat = (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 17, 1) * 90.0 / 8388608.0;
        double Long2 = (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 20, 1) * 180.0 / 8388608.0;
        double NorthVel = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 23, 1) * 120.0 / 32768.0;
        double WestVel = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 25, 1) * 120.0 / 32768.0;
        this.InterpretedFrame = this.InterpretIntegerAsBin(Status1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsBin(Status2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Hour);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Ageing);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(NorthVel);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(WestVel);
        if (this.GetCurvePlotImplementation()) {
            int Status_IpAddress = Status1 & 0x18;
            int Status_HRPVal = (Status1 &= 0x27) & 1;
            int Status_MalFunction = Status1 & 2;
            int Status_Alignment = Status1 & 4;
            int Status_Simulation = Status1 & 0x20;
            this.Encod.setValue(1028, Status_IpAddress, 1000);
            this.Encod.setValue(1025, Status_HRPVal, 1000);
            this.Encod.setValue(1021, Status_MalFunction, 1000);
            this.Encod.setValue(1004, Status_Simulation, 1000);
            this.Encod.setValue(1003, Status_Alignment, 1000);
            this.Encod.setValue(1000, Status1, 1000);
            this.Encod.setValue(100, Float.valueOf((float)Hour), 33);
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            this.Encod.setValue(104, Float.valueOf(-((float)Roll)), 1);
            this.Encod.setValue(105, Float.valueOf((float)Pitch), 1);
            this.Encod.setValue(124, Float.valueOf((float)Lat), 1);
            Long2 = 360.0 - Long2;
            this.Encod.setValue(125, Float.valueOf((float)Long2), 1);
            this.Encod.setValue(136, Float.valueOf((float)NorthVel), 25);
            this.Encod.setValue(137, Float.valueOf(-((float)WestVel)), 25);
        }
        if (Detected_Frame[0] == 40) {
            double Date2 = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 27, 1);
            if (Date2 != 0.0) {
                this.InterpretedFrame = this.InterpretString("Date field error");
                this.InterpretedFrame_AddToList(this.InterpretedFrame);
                return -1;
            }
            double Heave = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 29, 1) * 360.0 / 32768.0;
            double EMLogSpeed = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 31, 1) * 120.0 / 32768.0;
            double VerticalSpeed = this.Convert_2Bytes_to_SignedInt(Detected_Frame, 33, 1);
            if (VerticalSpeed != 0.0) {
                this.InterpretedFrame = this.InterpretString("Vertical Speed field error");
                this.InterpretedFrame_AddToList(this.InterpretedFrame);
                return -1;
            }
            int LatStd_ScaleBit = Detected_Frame[35] % 2;
            Detected_Frame[35] = (byte)(Detected_Frame[35] & 0xFE);
            double LatStd = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 35, 1);
            if (LatStd_ScaleBit == 0) {
                LatStd = LatStd * 5.0 / 128.0;
            }
            int LongStd_ScaleBit = Detected_Frame[36] % 2;
            Detected_Frame[36] = (byte)(Detected_Frame[36] & 0xFE);
            double LongStd = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 36, 1);
            if (LongStd_ScaleBit == 0) {
                LongStd = (float)(LongStd * 5.0 / 128.0);
            }
            double HeadingStd = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 37, 1) / 32768.0;
            Detected_Frame[39] = (byte)(Detected_Frame[39] & 0xFE);
            double PosErr = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, 39, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Date2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heave);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(EMLogSpeed);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(VerticalSpeed);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LatStd);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LongStd);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(HeadingStd);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(PosErr);
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(148, Float.valueOf(-((float)Heave)), 11);
                this.Encod.setValue(241, Float.valueOf((float)EMLogSpeed), 25);
                this.Encod.setValue(129, Float.valueOf((float)LatStd), 14);
                this.Encod.setValue(130, Float.valueOf((float)LongStd), 14);
                this.Encod.setValue(107, Float.valueOf((float)HeadingStd), 1);
            }
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        LoggerDecoderFrame.FrameReady = true;
        return 0;
    }
}

