/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class DOLOG_HRP_Decoder
extends Decoder {
    private Encoder Encod;

    public DOLOG_HRP_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 2;
        int Length_Blk = 16;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Status" + sep + "Heading(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Heading Rate(\u00b0/s)" + sep + "Roll Rate(\u00b0/s)" + sep + "Pitch Rate(\u00b0/s)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        int StartingByte = this.Convert_1Byte_to_SignedInt(Detected_Frame, 0, 1);
        if (StartingByte != 2) {
            this.InterpretedFrame_AddToList("Wrong start of sentence (0x2 expected)");
            return -1;
        }
        int Status = this.Convert_1Byte_to_SignedInt(Detected_Frame, 1, 1);
        Float Head = Float.valueOf((float)((double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 2, 1) * 180.0 / 32768.0));
        Float Roll = Float.valueOf((float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 4, 1) * 90.0 / 32768.0));
        Float Pitch = Float.valueOf((float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 6, 1) * 90.0 / 32768.0));
        Float HeadRate = Float.valueOf((float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 8, 1) * 45.0 / 32768.0));
        Float RollRate = Float.valueOf((float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 10, 1) * 45.0 / 32768.0));
        Float PitchRate = Float.valueOf((float)((double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 12, 1) * 45.0 / 32768.0));
        this.InterpretedFrame = this.InterpretIntegerAsInt(Status);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Head.floatValue(), 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Roll.floatValue(), 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Pitch.floatValue(), 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeadRate.floatValue(), 110);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RollRate.floatValue(), 111);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PitchRate.floatValue(), 112);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(103, Head, 1);
            this.Encod.setValue(104, Roll, 1);
            this.Encod.setValue(105, Float.valueOf(-Pitch.floatValue()), 1);
            this.Encod.setValue(110, Float.valueOf(-HeadRate.floatValue()), 51);
            this.Encod.setValue(111, RollRate, 51);
            this.Encod.setValue(112, Float.valueOf(-PitchRate.floatValue()), 51);
            this.Encod.setValue(1000, Status, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

