/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;

class DataBlk_Item
extends Decoder {
    int KeyId;
    double Time;
    byte[] cXorFields = new byte[24];
    float RotRateXv1;
    float RotRateXv2;
    float RotRateXv3;
    float AccXv1;
    float AccXv2;
    float AccXv3;
    long SensorSta1;
    float[] TemperaturesRec = new float[8];
    float[] TemperaturesMem = new float[8];
    boolean[] TemperaturesValid = new boolean[8];

    public DataBlk_Item() {
        this.DataBlk_Item_Reset();
    }

    private void DataBlk_Item_Reset() {
        this.RotRateXv1 = 0.0f;
        this.RotRateXv2 = 0.0f;
        this.RotRateXv3 = 0.0f;
        this.AccXv1 = 0.0f;
        this.AccXv2 = 0.0f;
        this.AccXv3 = 0.0f;
        this.SensorSta1 = 0L;
        for (int i = 0; i < 8; ++i) {
            this.TemperaturesRec[i] = 0.0f;
            this.TemperaturesMem[i] = 0.0f;
        }
    }

    public void DataBlk_Item_SetLastMemTemp(float[] Temp) {
        for (int i = 0; i < 8; ++i) {
            this.TemperaturesMem[i] = Temp[i];
        }
    }

    public void DataBlk_Item_GetLastMemTemp(float[] Temp) {
        for (int i = 0; i < 8; ++i) {
            Temp[i] = this.TemperaturesMem[i];
        }
    }

    public void DataBlk_Item_Set(byte[] Detected_Frame, int index) {
        this.KeyId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, index + 2, 1);
        this.Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 3, 1) * 5.0E-5;
        int i = 0;
        int n = index + 7;
        while (i < 24) {
            this.cXorFields[i] = Detected_Frame[n];
            ++i;
            ++n;
        }
        this.SensorSta1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 31, 1);
        if (Detected_Frame[1] == 0 || Detected_Frame[1] == 2) {
            short TempIndex = Detected_Frame[index + 35];
            for (int i2 = 0; i2 < 8; ++i2) {
                this.TemperaturesRec[i2] = 0.0f;
                this.TemperaturesValid[i2] = false;
            }
            float Temp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 36, 1);
            if (Detected_Frame[1] == 0) {
                Temp = this.daK_To_DegCelsius(Temp);
            }
            this.TemperaturesRec[TempIndex] = Temp;
            this.TemperaturesValid[TempIndex] = true;
        } else if (Detected_Frame[1] == 1) {
            for (i = 0; i < 8; ++i) {
                float Temp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 35 + 4 * i, 1);
                this.TemperaturesRec[i] = this.daK_To_DegCelsius(Temp);
                this.TemperaturesValid[i] = true;
            }
        }
    }

    public void DataBlk_Item_Decode(long RotRateXv1_Key, long RotRateXv2_Key, long RotRateXv3_Key, long AccXv1_Key, long AccXv2_Key, long AccXv3_Key) {
        byte RotRateXv1_Key_000000FF = (byte)(RotRateXv1_Key & 0xFFL);
        byte RotRateXv1_Key_0000FF00 = (byte)(RotRateXv1_Key >> 8 & 0xFFL);
        byte RotRateXv1_Key_00FF0000 = (byte)(RotRateXv1_Key >> 16 & 0xFFL);
        byte RotRateXv1_Key_FF000000 = (byte)(RotRateXv1_Key >> 24 & 0xFFL);
        byte RotRateXv2_Key_000000FF = (byte)(RotRateXv2_Key & 0xFFL);
        byte RotRateXv2_Key_0000FF00 = (byte)(RotRateXv2_Key >> 8 & 0xFFL);
        byte RotRateXv2_Key_00FF0000 = (byte)(RotRateXv2_Key >> 16 & 0xFFL);
        byte RotRateXv2_Key_FF000000 = (byte)(RotRateXv2_Key >> 24 & 0xFFL);
        byte RotRateXv3_Key_000000FF = (byte)(RotRateXv3_Key & 0xFFL);
        byte RotRateXv3_Key_0000FF00 = (byte)(RotRateXv3_Key >> 8 & 0xFFL);
        byte RotRateXv3_Key_00FF0000 = (byte)(RotRateXv3_Key >> 16 & 0xFFL);
        byte RotRateXv3_Key_FF000000 = (byte)(RotRateXv3_Key >> 24 & 0xFFL);
        byte AccXv1_Key_000000FF = (byte)(AccXv1_Key & 0xFFL);
        byte AccXv1_Key_0000FF00 = (byte)(AccXv1_Key >> 8 & 0xFFL);
        byte AccXv1_Key_00FF0000 = (byte)(AccXv1_Key >> 16 & 0xFFL);
        byte AccXv1_Key_FF000000 = (byte)(AccXv1_Key >> 24 & 0xFFL);
        byte AccXv2_Key_000000FF = (byte)(AccXv2_Key & 0xFFL);
        byte AccXv2_Key_0000FF00 = (byte)(AccXv2_Key >> 8 & 0xFFL);
        byte AccXv2_Key_00FF0000 = (byte)(AccXv2_Key >> 16 & 0xFFL);
        byte AccXv2_Key_FF000000 = (byte)(AccXv2_Key >> 24 & 0xFFL);
        byte AccXv3_Key_000000FF = (byte)(AccXv3_Key & 0xFFL);
        byte AccXv3_Key_0000FF00 = (byte)(AccXv3_Key >> 8 & 0xFFL);
        byte AccXv3_Key_00FF0000 = (byte)(AccXv3_Key >> 16 & 0xFFL);
        byte AccXv3_Key_FF000000 = (byte)(AccXv3_Key >> 24 & 0xFFL);
        this.cXorFields[0] = (byte)(this.cXorFields[0] ^ RotRateXv1_Key_000000FF);
        this.cXorFields[1] = (byte)(this.cXorFields[1] ^ RotRateXv1_Key_0000FF00);
        this.cXorFields[2] = (byte)(this.cXorFields[2] ^ RotRateXv1_Key_00FF0000);
        this.cXorFields[3] = (byte)(this.cXorFields[3] ^ RotRateXv1_Key_FF000000);
        this.cXorFields[4] = (byte)(this.cXorFields[4] ^ RotRateXv2_Key_000000FF);
        this.cXorFields[5] = (byte)(this.cXorFields[5] ^ RotRateXv2_Key_0000FF00);
        this.cXorFields[6] = (byte)(this.cXorFields[6] ^ RotRateXv2_Key_00FF0000);
        this.cXorFields[7] = (byte)(this.cXorFields[7] ^ RotRateXv2_Key_FF000000);
        this.cXorFields[8] = (byte)(this.cXorFields[8] ^ RotRateXv3_Key_000000FF);
        this.cXorFields[9] = (byte)(this.cXorFields[9] ^ RotRateXv3_Key_0000FF00);
        this.cXorFields[10] = (byte)(this.cXorFields[10] ^ RotRateXv3_Key_00FF0000);
        this.cXorFields[11] = (byte)(this.cXorFields[11] ^ RotRateXv3_Key_FF000000);
        this.cXorFields[12] = (byte)(this.cXorFields[12] ^ AccXv1_Key_000000FF);
        this.cXorFields[13] = (byte)(this.cXorFields[13] ^ AccXv1_Key_0000FF00);
        this.cXorFields[14] = (byte)(this.cXorFields[14] ^ AccXv1_Key_00FF0000);
        this.cXorFields[15] = (byte)(this.cXorFields[15] ^ AccXv1_Key_FF000000);
        this.cXorFields[16] = (byte)(this.cXorFields[16] ^ AccXv2_Key_000000FF);
        this.cXorFields[17] = (byte)(this.cXorFields[17] ^ AccXv2_Key_0000FF00);
        this.cXorFields[18] = (byte)(this.cXorFields[18] ^ AccXv2_Key_00FF0000);
        this.cXorFields[19] = (byte)(this.cXorFields[19] ^ AccXv2_Key_FF000000);
        this.cXorFields[20] = (byte)(this.cXorFields[20] ^ AccXv3_Key_000000FF);
        this.cXorFields[21] = (byte)(this.cXorFields[21] ^ AccXv3_Key_0000FF00);
        this.cXorFields[22] = (byte)(this.cXorFields[22] ^ AccXv3_Key_00FF0000);
        this.cXorFields[23] = (byte)(this.cXorFields[23] ^ AccXv3_Key_FF000000);
        this.RotRateXv1 = this.Convert_4Bytes_to_Float(this.cXorFields, 0, 1);
        this.RotRateXv2 = this.Convert_4Bytes_to_Float(this.cXorFields, 4, 1);
        this.RotRateXv3 = this.Convert_4Bytes_to_Float(this.cXorFields, 8, 1);
        this.AccXv1 = this.Convert_4Bytes_to_Float(this.cXorFields, 12, 1);
        this.AccXv2 = this.Convert_4Bytes_to_Float(this.cXorFields, 16, 1);
        this.AccXv3 = this.Convert_4Bytes_to_Float(this.cXorFields, 20, 1);
        for (int i = 0; i < 8; ++i) {
            if (!this.TemperaturesValid[i]) continue;
            this.TemperaturesMem[i] = this.TemperaturesRec[i];
        }
    }

    private float daK_To_DegCelsius(float daKTemp) {
        float DegCelsiusTemp = (float)((double)daKTemp / 10.0 - 273.15);
        return DegCelsiusTemp;
    }
}

