/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class GAPS_BIN_Decoder
extends Decoder {
    private Encoder Encod;

    public GAPS_BIN_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 84;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Day" + sep + "Hour" + sep + "Min" + sep + "Sec" + sep + "MicroSec" + sep + "Heading" + sep + "Roll" + sep + "Pitch" + sep + "Latitude" + sep + "Longitude" + sep + "Altitude" + sep + "VNord" + sep + "VOuest" + sep + "VHaut" + sep + "Heave" + sep + "ETLat" + sep + "ETLong" + sep + "ETAlt" + sep + "ETCap" + sep + "ETRoulis" + sep + "ETTangage" + sep + "CRC";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        int Spare = (this.Bytes_Frame[1] >> 4) * 10 + (this.Bytes_Frame[1] & 0xF);
        int Hour = (this.Bytes_Frame[3] >> 4) * 10 + (this.Bytes_Frame[3] & 0xF);
        int Minute = (this.Bytes_Frame[4] >> 4) * 10 + (this.Bytes_Frame[4] & 0xF);
        int Day = (this.Bytes_Frame[2] >> 4) * 10 + (this.Bytes_Frame[2] & 0xF);
        int Seconds = (this.Bytes_Frame[5] >> 4) * 10 + (this.Bytes_Frame[5] & 0xF);
        int CentiSeconds = (this.Bytes_Frame[6] >> 4) * 10 + (this.Bytes_Frame[6] & 0xF);
        int CentiMsec = (this.Bytes_Frame[7] >> 4) * 10 + (this.Bytes_Frame[7] & 0xF);
        int MicroSec = (this.Bytes_Frame[8] >> 4) * 10 + (this.Bytes_Frame[8] & 0xF);
        MicroSec += CentiMsec * 100 + CentiSeconds * 10000;
        long SysStatus = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 9, 1);
        long AlgoStatus = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 13, 1);
        float Heading = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 17, 1);
        float Roll = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 21, 1);
        float Pitch = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 25, 1);
        float Latitude = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 29, 1) / 2.147483648E9 * 90.0);
        float Longitude = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 33, 1) / 2.147483648E9 * 180.0);
        float Altitude = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 37, 1);
        float VN = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 41, 1);
        float VO = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 45, 1);
        float VU = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 49, 1);
        float Heave = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 53, 1);
        float ETLat = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 57, 1);
        float ETLong = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 61, 1);
        float ETAlt = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 65, 1);
        float ETH = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 69, 1);
        float ETR = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 73, 1);
        float ETP = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 77, 1);
        int Crc = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 81, 1);
        if (this.Bytes_Frame[83] != 35) {
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(1000, SysStatus, 1000);
            this.Encod.setValue(606, Integer.toHexString((int)AlgoStatus), 1000);
            this.Encod.setValue(103, Float.valueOf(Heading), 2);
            this.Encod.setValue(107, Float.valueOf(ETH), 2);
            this.Encod.setValue(104, Float.valueOf(Roll), 2);
            this.Encod.setValue(108, Float.valueOf(ETR), 2);
            this.Encod.setValue(105, Float.valueOf(Pitch), 2);
            this.Encod.setValue(109, Float.valueOf(ETP), 2);
            this.Encod.setValue(124, Float.valueOf(Latitude), 1);
            this.Encod.setValue(129, Float.valueOf(ETLat), 11);
            this.Encod.setValue(125, Float.valueOf(Longitude), 1);
            this.Encod.setValue(130, Float.valueOf(ETLong), 11);
            this.Encod.setValue(126, Float.valueOf(Altitude), 11);
            this.Encod.setValue(131, Float.valueOf(ETAlt), 11);
            this.Encod.setValue(136, Float.valueOf(VN), 21);
            this.Encod.setValue(137, Float.valueOf(-VO), 21);
            this.Encod.setValue(138, Float.valueOf(VU), 21);
            this.Encod.setValue(148, Float.valueOf(Heave), 11);
            this.Encod.setValue(724, Crc, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

