/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HEHDT_HEROT_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;
    private String HEHDT_heading = "0";

    public HEHDT_HEROT_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
            return -1;
        }
        if (params[0].contentEquals("$HEHDT")) {
            if (params.length != 4) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            if (!params[2].contentEquals("T")) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            if (params[1].isEmpty()) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error:");
                return -1;
            }
            if (!RegExp.is_ns_fpt2fpt5(params[1])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading format error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.HEHDT_heading = params[1];
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[0].contentEquals("$HEROT")) {
            if (params.length != 4) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
                return -1;
            }
            if (!RegExp.is_fpt2fpt4(params[1])) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading rate of turn format error");
                return -1;
            }
            Pattern p = Pattern.compile("(A?|V?)");
            Matcher m = p.matcher(params[2]);
            if (!m.matches()) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Valid status field format error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                int Status_HRPVal = 0;
                if ("A".equals(params[2])) {
                    Status_HRPVal = 65;
                }
                if ("V".equals(params[2])) {
                    Status_HRPVal = 86;
                }
                this.Encod.setValue(103, Float.valueOf(new Double(this.HEHDT_heading).floatValue()), 1);
                this.Encod.setValue(110, (double)new Double(params[1]).floatValue() / 60.0, 51);
                this.Encod.setValue(1025, Status_HRPVal, 1000);
                LoggerDecoderFrame.FrameReady = true;
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error");
            return -1;
        }
        return 0;
    }
}

