/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class IMU_RAW_DATA_Decoder
extends Decoder {
    private Encoder Encod;

    public IMU_RAW_DATA_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 85;
        int Length_Blk = 32;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Counter" + sep + "Status" + sep + "XV1_Rot" + sep + "XV2_Rot" + sep + "XV3_Rot" + sep + "XV1_Acc" + sep + "XV2_Acc" + sep + "XV3_Acc" + sep + "Temp";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        Integer Counter = this.Convert_1Byte_to_UnsignedInt(this.Bytes_Frame, 1, 1);
        Integer Status = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 2, 1);
        float XV1_Rot = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 4, 1);
        float XV2_Rot = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 8, 1);
        float XV3_Rot = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 12, 1);
        float XV1_Acc = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 16, 1);
        float XV2_Acc = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 20, 1);
        float XV3_Acc = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 24, 1);
        Integer Temp = this.Convert_1Byte_to_SignedInt(this.Bytes_Frame, 28, 1);
        this.InterpretedFrame = this.InterpretIntegerAsInt(Counter);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(Status);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1_Rot, 312);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2_Rot, 313);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3_Rot, 314);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1_Acc, 309);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2_Acc, 310);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3_Acc, 311);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Temp);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(312, Float.valueOf(XV1_Rot), 52);
            this.Encod.setValue(313, Float.valueOf(XV2_Rot), 52);
            this.Encod.setValue(314, Float.valueOf(XV3_Rot), 52);
            this.Encod.setValue(309, Float.valueOf(XV1_Acc), 43);
            this.Encod.setValue(310, Float.valueOf(XV2_Acc), 43);
            this.Encod.setValue(311, Float.valueOf(XV3_Acc), 43);
            this.Encod.setValue(469, Temp, 202);
            this.Encod.setValue(1000, Status, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

