/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class IMU_RD_Decoder
extends Decoder {
    public static final int DATABLOCK_LENGTH = 76;
    public static final int ASYNC_DATABLOCK_LENGTH = 80;

    public IMU_RD_Decoder(Encoder Encod) {
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 1;
        byte[] Start_Blk_n1 = new byte[Start_Blk_Length];
        byte[] Start_Blk_n2 = new byte[Start_Blk_Length];
        Start_Blk_n1[0] = -86;
        Start_Blk_n2[0] = 126;
        int Length_Blk_n1 = 76;
        int Length_Blk_n2 = 80;
        this.DecodeInit(0, Length_Blk_n1, Start_Blk_n1, Start_Blk_Length);
        this.DecodeInit(0, Length_Blk_n2, Start_Blk_n2, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "FogA_RotInc(inc)" + sep + "FogA_Ramp(inc)" + sep + "FogA_Vpi(inc)" + sep + "FogB_RotInc(inc)" + sep + "FogB_Ramp(inc)" + sep + "FogB_Vpi(inc)" + sep + "FogC_RotInc(inc)" + sep + "FogC_Ramp(inc)" + sep + "FogC_Vpi(inc)" + sep + "AccA_CumVal(inc)" + sep + "AccB_CumVal(inc)" + sep + "AccC_CumVal(inc)" + sep + "FogA_Temp(inc)" + sep + "FogB_Temp(inc)" + sep + "FogC_Temp(inc))" + sep + "AccA_Temp(inc)" + sep + "AccB_Temp(inc)" + sep + "AccC_Temp(inc))" + sep + "SorBoardTemp(inc)" + sep + "SrcBoardTemp(inc)" + sep + "MesPO(inc)" + sep + "MesDC(inc)" + sep + "GlobalStatus(Hexa)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        int endianness = 0;
        int index = 0;
        if (Length == 76 && Detected_Frame[0] != -86) {
            this.InterpretedFrame = "ERR0xAA: Unexpected start byte 1";
            return -1;
        }
        if (Length == 80) {
            int crc2;
            if (Detected_Frame[0] != 126) {
                this.InterpretedFrame = "ERR0x7E: Unexpected start byte 1";
                return -1;
            }
            if (Detected_Frame[1] != -86) {
                this.InterpretedFrame = "ERR0xAA: Unexpected start byte 2";
                return -1;
            }
            if (Detected_Frame[79] != 126) {
                this.InterpretedFrame = "ERR0x7E: Unexpected end byte";
                return -1;
            }
            int crc1 = this.Convert_2Bytes_to_SignedInt(Detected_Frame, 77, endianness);
            if (crc1 != (crc2 = this.Compute_CRC16_CCITT(Detected_Frame, 1, 76))) {
                this.InterpretedFrame = "ERR____: Unexpected checksum";
                return -1;
            }
            index = 1;
        }
        float FogA_RotInc = this.Convert_4Bytes_to_SignedInt(Detected_Frame, index + 1, endianness);
        int FogA_Ramp = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 5, endianness);
        int FogA_Vpi = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 7, endianness);
        float FogB_RotInc = this.Convert_4Bytes_to_SignedInt(Detected_Frame, index + 9, endianness);
        int FogB_Ramp = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 13, endianness);
        int FogB_Vpi = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 15, endianness);
        float FogC_RotInc = this.Convert_4Bytes_to_SignedInt(Detected_Frame, index + 17, endianness);
        int FogC_Ramp = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 21, endianness);
        int FogC_Vpi = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 23, endianness);
        float AccA_CumVal = this.Convert_4Bytes_to_SignedInt(Detected_Frame, index + 25, endianness);
        float AccB_CumVal = this.Convert_4Bytes_to_SignedInt(Detected_Frame, index + 29, endianness);
        float AccC_CumVal = this.Convert_4Bytes_to_SignedInt(Detected_Frame, index + 33, endianness);
        float FogA_Temp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 37, endianness);
        float FogB_Temp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 41, endianness);
        float FogC_Temp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 45, endianness);
        float AccA_Temp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 49, endianness);
        float AccB_Temp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 53, endianness);
        float AccC_Temp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 57, endianness);
        float SorBoardTemp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 61, endianness);
        float SrcBoardTemp = this.Convert_4Bytes_to_Float(Detected_Frame, index + 65, endianness);
        int MesOP = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 69, endianness);
        int MesDC = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, index + 71, endianness);
        long GlobalStatus = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 73, endianness);
        this.InterpretedFrame = this.InterpretFloat(FogA_RotInc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(FogA_Ramp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(FogA_Vpi);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogB_RotInc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(FogB_Ramp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(FogB_Vpi);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogC_RotInc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(FogC_Ramp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(FogC_Vpi);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccA_CumVal);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccB_CumVal);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccC_CumVal);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogA_Temp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogB_Temp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogC_Temp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccA_Temp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccB_Temp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccC_Temp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SorBoardTemp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SrcBoardTemp);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(MesOP);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(MesDC);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)GlobalStatus);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

