/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class IMU_SYS_FLOAT_Decoder
extends Decoder {
    public static final int DATABLOCK_LENGTH = 33;
    public static final int ASYNC_DATABLOCK_LENGTH = 37;
    private Encoder Encod;

    public IMU_SYS_FLOAT_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 1;
        byte[] Start_Blk_n1 = new byte[Start_Blk_Length];
        byte[] Start_Blk_n2 = new byte[Start_Blk_Length];
        Start_Blk_n1[0] = -89;
        Start_Blk_n2[0] = 126;
        int Length_Blk_n1 = 33;
        int Length_Blk_n2 = 37;
        this.DecodeInit(0, Length_Blk_n1, Start_Blk_n1, Start_Blk_Length);
        this.DecodeInit(0, Length_Blk_n2, Start_Blk_n2, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "TimeTag(us)" + sep + "FogX1Rot(rad)" + sep + "FogX2Rot(rad)" + sep + "FogX3Rot(rad)" + sep + "AccX1SpeedInc(m/s)" + sep + "AccX2SpeedInc(m/s)" + sep + "AccX3SpeedInc(m/s)" + sep + "GlobalStatus(Hexa)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        int endianness = 0;
        int index = 0;
        if (Length == 33 && Detected_Frame[0] != -89) {
            this.InterpretedFrame = "ERR0xA7: Unexpected start byte 1";
            return -1;
        }
        if (Length == 37) {
            int crc2;
            if (Detected_Frame[0] != 126) {
                this.InterpretedFrame = "ERR0x7E: Unexpected start byte 1";
                return -1;
            }
            if (Detected_Frame[36] != 126) {
                this.InterpretedFrame = "ERR0x7E: Unexpected end byte";
                return -1;
            }
            int crc1 = this.Convert_2Bytes_to_SignedInt(Detected_Frame, 34, endianness);
            if (crc1 != (crc2 = this.Compute_CRC16_CCITT(Detected_Frame, 1, 33))) {
                this.InterpretedFrame = "ERR____: Unexpected checksum";
                return -1;
            }
            index = 1;
        }
        double Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 1, endianness) * 25.0;
        float FogX1Rot = this.Convert_4Bytes_to_Float(Detected_Frame, index + 5, endianness);
        float FogX2Rot = this.Convert_4Bytes_to_Float(Detected_Frame, index + 9, endianness);
        float FogX3Rot = this.Convert_4Bytes_to_Float(Detected_Frame, index + 13, endianness);
        float AccX1SpeedInc = this.Convert_4Bytes_to_Float(Detected_Frame, index + 17, endianness);
        float AccX2SpeedInc = this.Convert_4Bytes_to_Float(Detected_Frame, index + 21, endianness);
        float AccX3SpeedInc = this.Convert_4Bytes_to_Float(Detected_Frame, index + 25, endianness);
        long GlobalStatus = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, index + 29, endianness);
        this.InterpretedFrame = this.InterpretDouble(Time);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogX1Rot);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogX2Rot);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogX3Rot);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccX1SpeedInc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccX2SpeedInc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccX3SpeedInc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)GlobalStatus);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

