/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.DecoderFIFO;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class IXBLUE_STD_BIN_Decoder
extends Decoder {
    public static final int CHK_LEN = 4;
    public static final int HDR_DATA_ID = 0;
    public static final int NAV_DATA_ID = 1;
    public static final int EXTENDED_NAV_DATA_ID = 2;
    public static final int EXT_DATA_ID = 3;
    public static final int DW_BIT00 = 1;
    public static final int DW_BIT01 = 2;
    public static final int DW_BIT02 = 4;
    public static final int DW_BIT03 = 8;
    public static final int DW_BIT04 = 16;
    public static final int DW_BIT05 = 32;
    public static final int DW_BIT06 = 64;
    public static final int DW_BIT07 = 128;
    public static final int DW_BIT08 = 256;
    public static final int DW_BIT09 = 512;
    public static final int DW_BIT10 = 1024;
    public static final int DW_BIT11 = 2048;
    public static final int DW_BIT12 = 4096;
    public static final int DW_BIT13 = 8192;
    public static final int DW_BIT14 = 16384;
    public static final int DW_BIT15 = 32768;
    public static final int DW_BIT16 = 65536;
    public static final int DW_BIT17 = 131072;
    public static final int DW_BIT18 = 262144;
    public static final int DW_BIT19 = 524288;
    public static final int DW_BIT20 = 0x100000;
    public static final int DW_BIT21 = 0x200000;
    public static final int DW_BIT22 = 0x400000;
    public static final int DW_BIT23 = 0x800000;
    public static final int DW_BIT24 = 0x1000000;
    public static final int DW_BIT25 = 0x2000000;
    public static final int DW_BIT26 = 0x4000000;
    public static final int DW_BIT27 = 0x8000000;
    public static final int DW_BIT28 = 0x10000000;
    public static final int DW_BIT29 = 0x20000000;
    public static final int DW_BIT30 = 0x40000000;
    public static final int DW_BIT31 = Integer.MIN_VALUE;
    DecoderFIFO FIFO;
    private Encoder Encod;

    public IXBLUE_STD_BIN_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.FIFO = new DecoderFIFO(6500);
        int Start_Blk_Length = 3;
        byte[] Start_Blk_V2 = new byte[Start_Blk_Length];
        Start_Blk_V2[0] = 73;
        Start_Blk_V2[1] = 88;
        Start_Blk_V2[2] = 2;
        this.DecodeInit(0, 0, Start_Blk_V2, Start_Blk_Length, 11, 1, 1);
        byte[] Start_Blk_V3 = new byte[Start_Blk_Length];
        Start_Blk_V3[0] = 73;
        Start_Blk_V3[1] = 88;
        Start_Blk_V3[2] = 3;
        this.DecodeInit(0, 0, Start_Blk_V3, Start_Blk_Length, 15, 1, 1);
        byte[] Start_Blk_V4 = new byte[Start_Blk_Length];
        Start_Blk_V4[0] = 73;
        Start_Blk_V4[1] = 88;
        Start_Blk_V4[2] = 4;
        this.DecodeInit(0, 0, Start_Blk_V4, Start_Blk_Length, 17, 1, 1);
        byte[] Start_Blk_V5 = new byte[Start_Blk_Length];
        Start_Blk_V5[0] = 73;
        Start_Blk_V5[1] = 88;
        Start_Blk_V5[2] = 5;
        this.DecodeInit(0, 0, Start_Blk_V5, Start_Blk_Length, 17, 1, 1);
    }

    @Override
    public String GetFileHeading() {
        String sep = "\t";
        this.Info.SetSeparator(sep);
        return "\r\nIXBLUE_STD_BIN decoder\r\nv2 Header line" + sep + ":" + sep + "0" + sep + "Header1" + sep + "Header2" + sep + "Version" + sep + "NavBitMask" + sep + "ExternalBitMask" + sep + "TelegramSize" + sep + "Time(s)" + sep + "Counter\r\nv3 Header line" + sep + ":" + sep + "0" + sep + "Header1" + sep + "Header2" + sep + "Version" + sep + "NavBitMask" + sep + "ExtendedNavBitMask" + sep + "ExternalBitMask" + sep + "TelegramSize" + sep + "Time(s)" + sep + "Counter\r\nv4 Header line" + sep + ":" + sep + "0" + sep + "Header1" + sep + "Header2" + sep + "Version" + sep + "NavBitMask" + sep + "ExtendedNavBitMask" + sep + "ExternalBitMask" + sep + "TelegramSize" + sep + "Time(s)" + sep + "Counter\r\nv5 Header line" + sep + ":" + sep + "0" + sep + "Header1" + sep + "Header2" + sep + "Version" + sep + "NavBitMask" + sep + "ExtendedNavBitMask" + sep + "ExternalBitMask" + sep + "TelegramSize" + sep + "Time(s)" + sep + "Counter\r\nNav Data lines" + sep + ":" + sep + "1" + sep + "Bit Nb" + sep + "and fields by reception order\r\nExtended Nav Data lines" + sep + ":" + sep + "2" + sep + "Bit Nb" + sep + "and fields by reception order\r\nExternal Data lines" + sep + ":" + sep + "3" + sep + "Bit Nb" + sep + "and fields by reception order";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        byte[] PopTelegramList = new byte[1024];
        this.FIFO.FIFO_Push(this.Bytes_Frame, Lenght);
        PopTelegramList = this.FIFO.FIFO_Pop();
        this.ProcessDetectedTelegram(PopTelegramList, Lenght);
        return 0;
    }

    public int ProcessDetectedTelegram(byte[] Detected_Frame, int Length) {
        long BitMask3;
        long BitMask2;
        long BitMask1;
        int BlocStart = 0;
        int shift = 0;
        int Version = 0;
        int TelegramSize = 0;
        int NavDataSize = 0;
        double Time = 0.0;
        double Counter = 0.0;
        Version = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + 2, 1);
        if (Version == 2) {
            TelegramSize = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 11, 1);
            BitMask1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 3, 1);
            BitMask2 = 0L;
            BitMask3 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 7, 1);
            Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 13, 1) * 1.0E-4;
            Counter = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 17, 1);
            shift = 21;
        } else if (Version == 3) {
            TelegramSize = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 15, 1);
            BitMask1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 3, 1);
            BitMask2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 7, 1);
            BitMask3 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 11, 1);
            Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 17, 1) * 1.0E-4;
            Counter = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 21, 1);
            shift = 25;
        } else if (Version == 4 | Version == 5) {
            NavDataSize = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 15, 1);
            TelegramSize = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 17, 1);
            BitMask1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 3, 1);
            BitMask2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 7, 1);
            BitMask3 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 11, 1);
            Time = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 19, 1) * 1.0E-4;
            Counter = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 23, 1);
            shift = 27;
        } else {
            return 0;
        }
        int ChkCal = 0;
        long ChkRead = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + TelegramSize - 4, 1);
        for (int i = 0; i < TelegramSize - 4; ++i) {
            ChkCal += this.Bytes_Frame[i] & 0xFF;
        }
        if ((long)ChkCal != ChkRead) {
            this.InterpretedFrame = this.InterpretString("Checksum error");
            return -1;
        }
        this.InterpretedFrame = "\n";
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(0);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Detected_Frame[0]);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Detected_Frame[1]);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Version);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(BitMask1);
        if (Version >= 3) {
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(BitMask2);
        }
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(BitMask3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(TelegramSize);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Counter, 0);
        this.InterpretedFrame = this.InterpretedFrame + "\n";
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(708, Detected_Frame[0], 1000);
            this.Encod.setValue(709, Detected_Frame[1], 1000);
            this.Encod.setValue(710, Version, 1000);
            this.Encod.setValue(712, BitMask1, 1000);
            if (Version >= 3) {
                this.Encod.setValue(713, BitMask2, 1000);
            }
            this.Encod.setValue(714, BitMask3, 1000);
            this.Encod.setValue(711, TelegramSize, 1000);
            this.Encod.setValue(101, Time, 31);
            this.Encod.setValue(701, Counter, 1000);
        }
        if ((BitMask1 & 1L) == 1L) {
            float Heading = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float Roll = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float Pitch = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(0);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heading, 103);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Roll, 104);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Pitch, 105);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(103, Float.valueOf(Heading), 1);
                this.Encod.setValue(104, Float.valueOf(Roll), 1);
                this.Encod.setValue(105, Float.valueOf(Pitch), 1);
            }
        }
        if ((BitMask1 & 2L) == 2L) {
            float HeadingStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float RollStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float PitchStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeadingStd, 107);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RollStd, 108);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PitchStd, 109);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(107, Float.valueOf(HeadingStd), 1);
                this.Encod.setValue(108, Float.valueOf(RollStd), 1);
                this.Encod.setValue(109, Float.valueOf(PitchStd), 1);
            }
        }
        if ((BitMask1 & 4L) == 4L) {
            float HeaveNla = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float Heave = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float Surge = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            float Sway = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 12, 1);
            shift += 16;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeaveNla, 149);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heave, 148);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Surge, 150);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Sway, 151);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(149, Float.valueOf(HeaveNla), 11);
                this.Encod.setValue(148, Float.valueOf(Heave), 11);
                this.Encod.setValue(150, Float.valueOf(Surge), 11);
                this.Encod.setValue(151, Float.valueOf(Sway), 11);
            }
        }
        if ((BitMask1 & 8L) == 8L) {
            double SmartHeaveTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            float SmartHeave = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            shift += 8;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(SmartHeaveTime, 342);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SmartHeave, 117);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(342, SmartHeaveTime, 31);
                this.Encod.setValue(117, Float.valueOf(SmartHeave), 11);
            }
        }
        if ((BitMask1 & 0x10L) == 16L) {
            float HeadingRate = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float RollRate = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float PitchRate = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeadingRate, 110);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RollRate, 111);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PitchRate, 112);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(110, Float.valueOf(HeadingRate), 51);
                this.Encod.setValue(111, Float.valueOf(RollRate), 51);
                this.Encod.setValue(112, Float.valueOf(PitchRate), 51);
            }
        }
        if ((BitMask1 & 0x20L) == 32L) {
            float XV1Rot = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float XV2Rot = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float XV3Rot = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(5);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1Rot, 312);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2Rot, 313);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3Rot, 314);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(409, Float.valueOf(XV1Rot), 51);
                this.Encod.setValue(410, Float.valueOf(XV2Rot), 51);
                this.Encod.setValue(411, Float.valueOf(XV3Rot), 51);
            }
        }
        if ((BitMask1 & 0x40L) == 64L) {
            float XV1Acc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float XV2Acc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float XV3Acc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1Acc, 309);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2Acc, 310);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3Acc, 311);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(338, Float.valueOf(XV1Acc), 43);
                this.Encod.setValue(339, Float.valueOf(XV2Acc), 43);
                this.Encod.setValue(340, Float.valueOf(XV3Acc), 43);
            }
        }
        if ((BitMask1 & 0x80L) == 128L) {
            double Latitude = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + shift, 1);
            double Longitude = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + shift + 8, 1);
            int AltitudeRef = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 16, 1);
            float Altitude = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 17, 1);
            shift += 21;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(7);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Latitude, 124);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Longitude, 125);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(AltitudeRef);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Altitude, 126);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(124, Latitude, 1);
                this.Encod.setValue(125, Longitude, 1);
                this.Encod.setValue(341, AltitudeRef, 1000);
                this.Encod.setValue(126, Float.valueOf(Altitude), 11);
            }
        }
        if ((BitMask1 & 0x100L) == 256L) {
            float LatitudeStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float LongitudeStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float CovLatLongStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            float AltitudeStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 12, 1);
            shift += 16;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LatitudeStd, 129);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LongitudeStd, 130);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(CovLatLongStd, 132);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AltitudeStd, 131);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(129, Float.valueOf(LatitudeStd), 11);
                this.Encod.setValue(130, Float.valueOf(LongitudeStd), 11);
                this.Encod.setValue(132, Float.valueOf(CovLatLongStd), 301);
                this.Encod.setValue(131, Float.valueOf(AltitudeStd), 11);
            }
        }
        if ((BitMask1 & 0x200L) == 512L) {
            float NorthSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float EastSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float VerticalSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(9);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(NorthSpeed, 136);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(EastSpeed, 137);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VerticalSpeed, 138);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(136, Float.valueOf(NorthSpeed), 21);
                this.Encod.setValue(137, Float.valueOf(EastSpeed), 21);
                this.Encod.setValue(138, Float.valueOf(VerticalSpeed), 21);
            }
        }
        if ((BitMask1 & 0x400L) == 1024L) {
            float NorthSpeedStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float EastSpeedStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float VerticalSpeedStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(10);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(NorthSpeedStd, 141);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(EastSpeedStd, 142);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VerticalSpeedStd, 143);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(141, Float.valueOf(NorthSpeedStd), 21);
                this.Encod.setValue(142, Float.valueOf(EastSpeedStd), 21);
                this.Encod.setValue(143, Float.valueOf(VerticalSpeedStd), 21);
            }
        }
        if ((BitMask1 & 0x800L) == 2048L) {
            float NorthCurrentSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float EastCurrentSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            shift += 8;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(11);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(NorthCurrentSpeed, 250);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(EastCurrentSpeed, 251);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(250, Float.valueOf(NorthCurrentSpeed), 21);
                this.Encod.setValue(251, Float.valueOf(EastCurrentSpeed), 21);
            }
        }
        if ((BitMask1 & 0x1000L) == 4096L) {
            float NorthCurrentSpeedStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float EastCurrentSpeedStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            shift += 8;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(12);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(NorthCurrentSpeedStd, 252);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(EastCurrentSpeedStd, 253);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(252, Float.valueOf(NorthCurrentSpeedStd), 21);
                this.Encod.setValue(253, Float.valueOf(EastCurrentSpeedStd), 21);
            }
        }
        if ((BitMask1 & 0x2000L) == 8192L) {
            int Day = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1);
            int Month = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 1, 1);
            int Year = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 2, 1);
            shift += 4;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(13);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Day);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Month);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Year);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(155, Day, 1000);
                this.Encod.setValue(156, Month, 1000);
                this.Encod.setValue(157, Year, 1000);
            }
        }
        if ((BitMask1 & 0x4000L) == 16384L) {
            long SorStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1);
            long SorStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
            shift += 8;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(14);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SorStatus1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SorStatus2);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(603, Integer.toHexString((int)SorStatus1), 1000);
                this.Encod.setValue(604, Integer.toHexString((int)SorStatus2), 1000);
            }
        }
        if ((BitMask1 & 0x8000L) == 32768L) {
            long AlgStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1);
            long AlgStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
            long AlgStatus3 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 8, 1);
            long AlgStatus4 = Version >= 2 ? this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 12, 1) : 0L;
            shift += Version >= 2 ? 16 : 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(15);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgStatus1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgStatus2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgStatus3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgStatus4);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(606, Integer.toHexString((int)AlgStatus1), 1000);
                this.Encod.setValue(607, Integer.toHexString((int)AlgStatus2), 1000);
                this.Encod.setValue(608, Integer.toHexString((int)AlgStatus3), 1000);
                this.Encod.setValue(609, Integer.toHexString((int)AlgStatus4), 1000);
            }
        }
        if ((BitMask1 & 0x40000L) == 262144L) {
            long AlgStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1);
            shift += 4;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(18);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgStatus1);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(606, Integer.toHexString((int)AlgStatus1), 1000);
            }
        }
        if ((BitMask1 & 0x10000L) == 65536L || (BitMask1 & 0x80000L) == 524288L) {
            long SysStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1);
            long SysStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
            long SysStatus3 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            if ((BitMask1 & 0x10000L) == 65536L) {
                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(16);
            }
            if ((BitMask1 & 0x80000L) == 524288L) {
                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(19);
            }
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SysStatus1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SysStatus2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SysStatus3);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(600, Integer.toHexString((int)SysStatus1), 1000);
                this.Encod.setValue(601, Integer.toHexString((int)SysStatus2), 1000);
                this.Encod.setValue(602, Integer.toHexString((int)SysStatus3), 1000);
            }
        }
        if ((BitMask1 & 0x20000L) == 131072L || (BitMask1 & 0x100000L) == 0x100000L) {
            long UserStatus = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1);
            shift += 4;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            if ((BitMask1 & 0x20000L) == 131072L) {
                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(17);
            }
            if ((BitMask1 & 0x100000L) == 0x100000L) {
                this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(20);
            }
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)UserStatus);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(610, Integer.toHexString((int)UserStatus), 1000);
            }
        }
        if ((BitMask1 & 0x200000L) == 0x200000L) {
            float HeaveSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float SurgeSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float SwaySpeed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(21);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeaveSpeed, 152);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SurgeSpeed, 153);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SwaySpeed, 154);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(152, Float.valueOf(HeaveSpeed), 21);
                this.Encod.setValue(153, Float.valueOf(SurgeSpeed), 21);
                this.Encod.setValue(154, Float.valueOf(SwaySpeed), 21);
            }
        }
        if ((BitMask1 & 0x400000L) == 0x400000L) {
            float XV1_Speed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float XV2_Speed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float XV3_Speed = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(22);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1_Speed, 133);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2_Speed, 134);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3_Speed, 135);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(133, Float.valueOf(XV1_Speed), 21);
                this.Encod.setValue(134, Float.valueOf(XV2_Speed), 21);
                this.Encod.setValue(135, Float.valueOf(XV3_Speed), 21);
            }
        }
        if ((BitMask1 & 0x800000L) == 0x800000L) {
            float NorthAcc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float EastAcc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float VertAcc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(23);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(NorthAcc, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(EastAcc, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VertAcc, 3);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(118, Float.valueOf(NorthAcc), 43);
                this.Encod.setValue(119, Float.valueOf(EastAcc), 43);
                this.Encod.setValue(120, Float.valueOf(VertAcc), 43);
            }
        }
        if ((BitMask1 & 0x1000000L) == 0x1000000L) {
            float Course = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float Norme = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            shift += 8;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(24);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Course, 147);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Norme, 146);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(147, Float.valueOf(Course), 1);
                this.Encod.setValue(146, Float.valueOf(Norme), 21);
            }
        }
        if ((BitMask1 & 0x2000000L) == 0x2000000L) {
            float fFog = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float fAcc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float fAna = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(25);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(fFog, 299);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(fAcc, 300);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(fAna, 301);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(299, Float.valueOf(fFog), 202);
                this.Encod.setValue(300, Float.valueOf(fAcc), 202);
                this.Encod.setValue(301, Float.valueOf(fAna), 202);
            }
        }
        if ((BitMask1 & 0x4000000L) == 0x4000000L) {
            int i;
            float[] AttQuat = new float[4];
            for (i = 0; i < 4; ++i) {
                AttQuat[i] = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4 * i, 1);
            }
            shift += 16;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(26);
            for (i = 0; i < 4; ++i) {
                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AttQuat[i], 327 + i);
            }
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(327, Float.valueOf(AttQuat[0]), 1000);
                this.Encod.setValue(328, Float.valueOf(AttQuat[1]), 1000);
                this.Encod.setValue(329, Float.valueOf(AttQuat[2]), 1000);
                this.Encod.setValue(330, Float.valueOf(AttQuat[3]), 1000);
            }
        }
        if ((BitMask1 & 0x8000000L) == 0x8000000L) {
            int i;
            float[] AttQuatStd = new float[4];
            for (i = 0; i < 3; ++i) {
                AttQuatStd[i] = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4 * i, 1);
            }
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(27);
            for (i = 0; i < 3; ++i) {
                this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AttQuatStd[i], 331 + i);
            }
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(331, Float.valueOf(AttQuatStd[0]), 1000);
                this.Encod.setValue(332, Float.valueOf(AttQuatStd[1]), 1000);
                this.Encod.setValue(333, Float.valueOf(AttQuatStd[2]), 1000);
            }
        }
        if ((BitMask1 & 0x10000000L) == 0x10000000L) {
            float XV1Acc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float XV2Acc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float XV3Acc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(28);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1Acc, 309);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2Acc, 310);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3Acc, 311);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(309, Float.valueOf(XV1Acc), 43);
                this.Encod.setValue(310, Float.valueOf(XV2Acc), 43);
                this.Encod.setValue(311, Float.valueOf(XV3Acc), 43);
            }
        }
        if ((BitMask1 & 0x20000000L) == 0x20000000L) {
            float XV1AccStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float XV2AccStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float XV3AccStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(29);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1AccStd, 315);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2AccStd, 316);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3AccStd, 317);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(315, Float.valueOf(XV1AccStd), 43);
                this.Encod.setValue(316, Float.valueOf(XV2AccStd), 43);
                this.Encod.setValue(317, Float.valueOf(XV3AccStd), 43);
            }
        }
        if ((BitMask1 & 0x40000000L) == 0x40000000L) {
            float XV1RotStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float XV2RotStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float XV3RotStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(30);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1RotStd, 318);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2RotStd, 319);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3RotStd, 320);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(318, Float.valueOf(XV1RotStd), 51);
                this.Encod.setValue(319, Float.valueOf(XV2RotStd), 51);
                this.Encod.setValue(320, Float.valueOf(XV3RotStd), 51);
            }
        }
        if ((BitMask2 & 1L) == 1L) {
            float XV1RotAcc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float XV2RotAcc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float XV3RotAcc = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(0);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1RotAcc, 321);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2RotAcc, 322);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3RotAcc, 323);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(321, Float.valueOf(XV1RotAcc), 44);
                this.Encod.setValue(322, Float.valueOf(XV2RotAcc), 44);
                this.Encod.setValue(323, Float.valueOf(XV3RotAcc), 44);
            }
        }
        if ((BitMask2 & 2L) == 2L) {
            float XV1RotAccStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float XV2RotAccStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float XV3RotAccStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1RotAccStd, 324);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2RotAccStd, 325);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3RotAccStd, 326);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(324, Float.valueOf(XV1RotAccStd), 44);
                this.Encod.setValue(325, Float.valueOf(XV2RotAccStd), 44);
                this.Encod.setValue(326, Float.valueOf(XV3RotAccStd), 44);
            }
        }
        if ((BitMask2 & 4L) == 4L) {
            float XV1Rot = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float XV2Rot = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float XV3Rot = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1Rot, 312);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2Rot, 313);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3Rot, 314);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(312, Float.valueOf(XV1Rot), 51);
                this.Encod.setValue(313, Float.valueOf(XV2Rot), 51);
                this.Encod.setValue(314, Float.valueOf(XV3Rot), 51);
            }
        }
        if ((BitMask2 & 8L) == 8L) {
            float PointingAngle_Heading = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float PointingAngle_Roll = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float PointingAngle_Pitch = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PointingAngle_Heading, 417);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PointingAngle_Roll, 418);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PointingAngle_Pitch, 419);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(417, Float.valueOf(PointingAngle_Heading), 1);
                this.Encod.setValue(418, Float.valueOf(PointingAngle_Roll), 1);
                this.Encod.setValue(419, Float.valueOf(PointingAngle_Pitch), 1);
            }
        }
        if ((BitMask2 & 0x10L) == 16L) {
            float PointingAngle_Heading_SD = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift, 1);
            float PointingAngle_Roll_SD = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float PointingAngle_Pitch_SD = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PointingAngle_Heading_SD, 420);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PointingAngle_Roll_SD, 421);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PointingAngle_Pitch_SD, 422);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(420, Float.valueOf(PointingAngle_Heading_SD), 1);
                this.Encod.setValue(421, Float.valueOf(PointingAngle_Roll_SD), 1);
                this.Encod.setValue(422, Float.valueOf(PointingAngle_Pitch_SD), 1);
            }
        }
        if ((BitMask3 & 1L) == 1L) {
            double UtcTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            int UtcSrc = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
            shift += 5;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(0);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(UtcTime, 8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(UtcSrc);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(100, UtcTime, 31);
            }
        }
        if ((BitMask3 & 2L) == 2L) {
            shift = this.F_Process_ExtGpsData(1, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 4L) == 4L) {
            shift = this.F_Process_ExtGpsData(2, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 8L) == 8L) {
            shift = this.F_Process_ExtGpsData(3, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x10L) == 16L) {
            shift = this.F_Process_ExtLemData(4, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x20L) == 32L) {
            shift = this.F_Process_ExtLemData(5, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x40L) == 64L) {
            shift = this.F_Process_ExtUsblData(6, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x80L) == 128L) {
            shift = this.F_Process_ExtUsblData(7, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x100L) == 256L) {
            shift = this.F_Process_ExtUsblData(8, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x200L) == 512L) {
            double DepthTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            float Depth = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float DepthStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            shift += 12;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(9);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(DepthTime, 8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Depth, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DepthStd, 3);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(244, DepthTime, 31);
                this.Encod.setValue(246, Float.valueOf(Depth), 11);
                this.Encod.setValue(247, Float.valueOf(DepthStd), 11);
            }
        }
        if ((BitMask3 & 0x400L) == 1024L) {
            shift = this.F_Process_ExtDvlBT(10, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x800L) == 2048L) {
            shift = this.F_Process_ExtDvlWT(11, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x1000L) == 4096L) {
            double UTCTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            float CTDSndVel = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            shift += 8;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(12);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(UTCTime, 8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(CTDSndVel, 3);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(206, Float.valueOf(CTDSndVel), 21);
            }
        }
        if ((BitMask3 & 0x2000L) == 8192L) {
            double DmiTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            float DmiV = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
            shift += 8;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(13);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(DmiTime, 8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(DmiV, 3);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(256, DmiTime, 31);
                this.Encod.setValue(257, Float.valueOf(DmiV), 21);
            }
        }
        if ((BitMask3 & 0x4000L) == 16384L) {
            shift = this.F_Process_ExtLblData(14, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x8000L) == 32768L) {
            shift = this.F_Process_ExtLblData(15, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x10000L) == 65536L) {
            shift = this.F_Process_ExtLblData(16, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x20000L) == 131072L) {
            this.F_Process_ExtLblData(17, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x40000L) == 262144L) {
            shift = this.F_Process_EventsMarker(18, Version, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x80000L) == 524288L) {
            shift = this.F_Process_EventsMarker(19, Version, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x100000L) == 0x100000L) {
            shift = this.F_Process_EventsMarker(20, Version, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x200000L) == 0x200000L) {
            shift = this.F_Process_ExtDvlBT(21, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x400000L) == 0x400000L) {
            shift = this.F_Process_ExtDvlWT(22, Detected_Frame, BlocStart, shift);
        }
        if ((BitMask3 & 0x800000L) == 0x800000L) {
            double IMUTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            float FOGX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float FOGY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            float FOGZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 12, 1);
            float ACCX = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 16, 1);
            float ACCY = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 20, 1);
            float ACCZ = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 24, 1);
            shift += 32;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(23);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(IMUTime, 8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FOGX, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FOGY, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FOGZ, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ACCX, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ACCY, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(ACCZ, 6);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                // empty if block
            }
        }
        if ((BitMask3 & 0x1000000L) == 0x1000000L) {
            double TurretDataTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            float TurretHeading = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 4, 1);
            float TurretRoll = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 8, 1);
            float TurretPitch = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 12, 1);
            shift += 16;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(24);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(TurretDataTime, 8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TurretHeading, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TurretRoll, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TurretPitch, 3);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(423, TurretDataTime, 31);
                this.Encod.setValue(424, Float.valueOf(TurretHeading), 1);
                this.Encod.setValue(425, Float.valueOf(TurretRoll), 1);
                this.Encod.setValue(426, Float.valueOf(TurretPitch), 1);
            }
        }
        if ((BitMask3 & 0x2000000L) == 0x2000000L) {
            double VTG1DataTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            int VTG1ID = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
            float VTG1TrueCourse = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 5, 1);
            float VTG1MagneticCourse = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 9, 1);
            float VTG1SpeedOverGround = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 13, 1);
            shift += 17;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(25);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(VTG1DataTime, 8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(VTG1ID);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VTG1TrueCourse, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VTG1MagneticCourse, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VTG1SpeedOverGround, 3);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(470, VTG1DataTime, 31);
                this.Encod.setValue(471, VTG1ID, 1000);
                this.Encod.setValue(472, Float.valueOf(VTG1TrueCourse), 1);
                this.Encod.setValue(473, Float.valueOf(VTG1MagneticCourse), 1);
                this.Encod.setValue(474, Float.valueOf(VTG1SpeedOverGround), 21);
            }
        }
        if ((BitMask3 & 0x4000000L) == 0x4000000L) {
            double VTG2DataTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            int VTG2ID = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
            float VTG2TrueCourse = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 5, 1);
            float VTG2MagneticCourse = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 9, 1);
            float VTG2SpeedOverGround = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 13, 1);
            shift += 17;
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(26);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(VTG2DataTime, 8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(VTG2ID);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VTG2TrueCourse, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VTG2MagneticCourse, 3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VTG2SpeedOverGround, 3);
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(470, VTG2DataTime, 31);
                this.Encod.setValue(472, Float.valueOf(VTG2TrueCourse), 1);
                this.Encod.setValue(473, Float.valueOf(VTG2MagneticCourse), 1);
                this.Encod.setValue(474, Float.valueOf(VTG2SpeedOverGround), 21);
            }
        }
        if ((BitMask3 & 0x8000000L) == 0x8000000L) {
            double LogbookDataTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
            double LogbookID = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
            String LogbookMessage = "";
            for (int i = 0; i < 32 && Detected_Frame[BlocStart + shift + 8 + i] != 0; ++i) {
                LogbookMessage = LogbookMessage + (char)Detected_Frame[BlocStart + shift + 8 + i];
            }
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(27);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LogbookDataTime, 8);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LogbookID);
            this.InterpretedFrame = this.InterpretedFrame + LogbookMessage;
            this.InterpretedFrame = this.InterpretedFrame + "\n";
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(480, LogbookDataTime, 31);
                this.Encod.setValue(481, LogbookID, 1000);
                this.Encod.setValue(482, LogbookMessage, 1000);
            }
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        LoggerDecoderFrame.FrameReady = true;
        return 0;
    }

    private int F_Process_ExtGpsData(int DataID, byte[] Detected_Frame, int BlocStart, int shift) {
        double GpsTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
        int GpsId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
        int Quality = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 5, 1);
        double Lat = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + shift + 6, 1);
        double Long2 = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + shift + 14, 1);
        float Altitude = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 22, 1);
        float LatStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 26, 1);
        float LongStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 30, 1);
        float AltiStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 34, 1);
        float CovLatLong = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 38, 1);
        float GeoidalSep = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 42, 1);
        shift += 46;
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(DataID);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(GpsTime, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(GpsId);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Quality);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Altitude, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LatStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LongStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AltiStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(CovLatLong, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(GeoidalSep, 3);
        this.InterpretedFrame = this.InterpretedFrame + "\n";
        if (this.GetCurvePlotImplementation()) {
            switch (DataID) {
                case 1: {
                    this.Encod.setValue(405, GpsId, 1000);
                    this.Encod.setValue(160, GpsTime, 31);
                    this.Encod.setValue(165, Quality, 1000);
                    this.Encod.setValue(162, Lat, 1);
                    this.Encod.setValue(163, Long2, 1);
                    this.Encod.setValue(164, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(166, Float.valueOf(LatStd), 11);
                    this.Encod.setValue(167, Float.valueOf(LongStd), 11);
                    this.Encod.setValue(168, Float.valueOf(AltiStd), 11);
                    this.Encod.setValue(169, Float.valueOf(CovLatLong), 301);
                    this.Encod.setValue(170, Float.valueOf(GeoidalSep), 11);
                    break;
                }
                case 2: {
                    this.Encod.setValue(406, GpsId, 1000);
                    this.Encod.setValue(171, GpsTime, 31);
                    this.Encod.setValue(176, Quality, 1000);
                    this.Encod.setValue(173, Lat, 1);
                    this.Encod.setValue(174, Long2, 1);
                    this.Encod.setValue(175, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(177, Float.valueOf(LatStd), 11);
                    this.Encod.setValue(178, Float.valueOf(LongStd), 11);
                    this.Encod.setValue(179, Float.valueOf(AltiStd), 11);
                    this.Encod.setValue(180, Float.valueOf(CovLatLong), 301);
                    this.Encod.setValue(181, Float.valueOf(GeoidalSep), 11);
                    break;
                }
                case 3: {
                    this.Encod.setValue(407, GpsId, 1000);
                    this.Encod.setValue(182, GpsTime, 31);
                    this.Encod.setValue(187, Quality, 1000);
                    this.Encod.setValue(184, Lat, 1);
                    this.Encod.setValue(185, Long2, 1);
                    this.Encod.setValue(186, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(188, Float.valueOf(LatStd), 11);
                    this.Encod.setValue(189, Float.valueOf(LongStd), 11);
                    this.Encod.setValue(190, Float.valueOf(AltiStd), 11);
                    this.Encod.setValue(191, Float.valueOf(CovLatLong), 301);
                    this.Encod.setValue(192, Float.valueOf(GeoidalSep), 11);
                }
            }
        }
        return shift;
    }

    private int F_Process_ExtLemData(int DataID, byte[] Detected_Frame, int BlocStart, int shift) {
        double LemTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
        int LemId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
        float Vx = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 5, 1);
        float VxStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 9, 1);
        shift += 13;
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(DataID);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LemTime, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(LemId);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Vx, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VxStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + "\n";
        if (this.GetCurvePlotImplementation()) {
            switch (DataID) {
                case 4: {
                    this.Encod.setValue(238, LemId, 1000);
                    this.Encod.setValue(239, LemTime, 31);
                    this.Encod.setValue(241, Float.valueOf(Vx), 21);
                    this.Encod.setValue(242, Float.valueOf(VxStd), 21);
                    break;
                }
                case 5: {
                    this.Encod.setValue(343, LemId, 1000);
                    this.Encod.setValue(344, LemTime, 31);
                    this.Encod.setValue(346, Float.valueOf(Vx), 21);
                    this.Encod.setValue(347, Float.valueOf(VxStd), 21);
                }
            }
        }
        return shift;
    }

    private int F_Process_ExtUsblData(int DataID, byte[] Detected_Frame, int BlocStart, int shift) {
        char[] TpCode = new char[8];
        double UsblTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
        int UsblId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
        for (int i = 0; i < 8; ++i) {
            TpCode[i] = (char)Detected_Frame[BlocStart + shift + 5 + i];
        }
        double Lat = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + shift + 13, 1);
        double Long2 = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + shift + 21, 1);
        float Altitude = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 29, 1);
        float LatStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 33, 1);
        float LongStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 37, 1);
        float CovLatLong = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 41, 1);
        float AltiStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 45, 1);
        shift += 49;
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(DataID);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(UsblTime, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(UsblId);
        for (int i = 0; i < 8; ++i) {
            if (TpCode[i] == '\u0000') continue;
            this.InterpretedFrame = this.InterpretedFrame + TpCode[i];
        }
        this.InterpretedFrame = this.InterpretedFrame + this.Info.GetSeparator();
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Altitude, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LatStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(LongStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(CovLatLong, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AltiStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + "\n";
        if (this.GetCurvePlotImplementation()) {
            switch (DataID) {
                case 6: {
                    this.Encod.setValue(193, UsblId, 1000);
                    this.Encod.setValue(194, UsblId, 1000);
                    this.Encod.setValue(196, UsblTime, 31);
                    this.Encod.setValue(198, Lat, 1);
                    this.Encod.setValue(199, Long2, 1);
                    this.Encod.setValue(200, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(201, Float.valueOf(LatStd), 11);
                    this.Encod.setValue(202, Float.valueOf(LongStd), 11);
                    this.Encod.setValue(203, Float.valueOf(AltiStd), 11);
                    this.Encod.setValue(204, Float.valueOf(CovLatLong), 301);
                    break;
                }
                case 7: {
                    this.Encod.setValue(349, UsblId, 1000);
                    this.Encod.setValue(350, UsblId, 1000);
                    this.Encod.setValue(352, UsblTime, 31);
                    this.Encod.setValue(354, Lat, 1);
                    this.Encod.setValue(355, Long2, 1);
                    this.Encod.setValue(356, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(357, Float.valueOf(LatStd), 11);
                    this.Encod.setValue(358, Float.valueOf(LongStd), 11);
                    this.Encod.setValue(359, Float.valueOf(AltiStd), 11);
                    this.Encod.setValue(360, Float.valueOf(CovLatLong), 301);
                    break;
                }
                case 8: {
                    this.Encod.setValue(362, UsblId, 1000);
                    this.Encod.setValue(363, UsblId, 1000);
                    this.Encod.setValue(365, UsblTime, 31);
                    this.Encod.setValue(367, Lat, 1);
                    this.Encod.setValue(368, Long2, 1);
                    this.Encod.setValue(369, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(370, Float.valueOf(LatStd), 11);
                    this.Encod.setValue(371, Float.valueOf(LongStd), 11);
                    this.Encod.setValue(372, Float.valueOf(AltiStd), 11);
                    this.Encod.setValue(373, Float.valueOf(CovLatLong), 301);
                }
            }
        }
        return shift;
    }

    private int F_Process_ExtLblData(int DataID, byte[] Detected_Frame, int BlocStart, int shift) {
        char[] TpCode = new char[8];
        double LblTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
        int LblId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
        for (int i = 0; i < 8; ++i) {
            TpCode[i] = (char)Detected_Frame[BlocStart + shift + 5 + i];
        }
        double Lat = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + shift + 13, 1);
        double Long2 = this.Convert_8Bytes_to_Double(Detected_Frame, BlocStart + shift + 21, 1);
        float Altitude = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 29, 1);
        float Range = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 33, 1);
        float RangeStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 37, 1);
        shift += 41;
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(DataID);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(LblTime, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(LblId);
        for (int i = 0; i < 8; ++i) {
            if (TpCode[i] == '\u0000') continue;
            this.InterpretedFrame = this.InterpretedFrame + TpCode[i];
        }
        this.InterpretedFrame = this.InterpretedFrame + this.Info.GetSeparator();
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Altitude, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Range, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RangeStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + "\n";
        String sTpCode = new String(TpCode);
        if (this.GetCurvePlotImplementation()) {
            switch (DataID) {
                case 14: {
                    this.Encod.setValue(228, LblId, 1000);
                    this.Encod.setValue(229, sTpCode, 1000);
                    this.Encod.setValue(230, LblTime, 31);
                    this.Encod.setValue(232, Lat, 1);
                    this.Encod.setValue(233, Long2, 1);
                    this.Encod.setValue(234, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(235, Float.valueOf(Range), 11);
                    this.Encod.setValue(236, Float.valueOf(RangeStd), 11);
                    break;
                }
                case 15: {
                    this.Encod.setValue(375, LblId, 1000);
                    this.Encod.setValue(376, sTpCode, 1000);
                    this.Encod.setValue(377, LblTime, 31);
                    this.Encod.setValue(379, Lat, 1);
                    this.Encod.setValue(380, Long2, 1);
                    this.Encod.setValue(381, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(382, Float.valueOf(Range), 11);
                    this.Encod.setValue(383, Float.valueOf(RangeStd), 11);
                    break;
                }
                case 16: {
                    this.Encod.setValue(385, LblId, 1000);
                    this.Encod.setValue(386, sTpCode, 1000);
                    this.Encod.setValue(387, LblTime, 31);
                    this.Encod.setValue(389, Lat, 1);
                    this.Encod.setValue(390, Long2, 1);
                    this.Encod.setValue(391, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(392, Float.valueOf(Range), 11);
                    this.Encod.setValue(393, Float.valueOf(RangeStd), 11);
                    break;
                }
                case 17: {
                    this.Encod.setValue(395, LblId, 1000);
                    this.Encod.setValue(396, sTpCode, 1000);
                    this.Encod.setValue(397, LblTime, 31);
                    this.Encod.setValue(399, Lat, 1);
                    this.Encod.setValue(400, Long2, 1);
                    this.Encod.setValue(401, Float.valueOf(Altitude), 11);
                    this.Encod.setValue(402, Float.valueOf(Range), 11);
                    this.Encod.setValue(403, Float.valueOf(RangeStd), 11);
                }
            }
        }
        return shift;
    }

    private int F_Process_ExtDvlBT(int DataID, byte[] Detected_Frame, int BlocStart, int shift) {
        double DvlTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
        int DvlId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
        float Vx = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 5, 1);
        float Vy = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 9, 1);
        float Vz = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 13, 1);
        float SoundVel = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 17, 1);
        float Alti = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 21, 1);
        float VxStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 25, 1);
        float VyStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 29, 1);
        float VzStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 33, 1);
        shift += 37;
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(DataID);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(DvlTime, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(DvlId);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Vx, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Vy, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Vz, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SoundVel, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Alti, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VxStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VyStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VzStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + "\n";
        if (this.GetCurvePlotImplementation()) {
            switch (DataID) {
                case 10: {
                    this.Encod.setValue(207, DvlId, 1000);
                    this.Encod.setValue(219, DvlTime, 31);
                    this.Encod.setValue(221, Float.valueOf(Vx), 21);
                    this.Encod.setValue(222, Float.valueOf(Vy), 21);
                    this.Encod.setValue(223, Float.valueOf(Vz), 21);
                    this.Encod.setValue(209, Float.valueOf(SoundVel), 21);
                    this.Encod.setValue(208, Float.valueOf(Alti), 11);
                    this.Encod.setValue(224, Float.valueOf(VxStd), 21);
                    this.Encod.setValue(225, Float.valueOf(VyStd), 21);
                    this.Encod.setValue(226, Float.valueOf(VzStd), 21);
                    break;
                }
                case 21: {
                    this.Encod.setValue(408, DvlId, 1000);
                    this.Encod.setValue(285, DvlTime, 31);
                    this.Encod.setValue(287, Float.valueOf(Vx), 21);
                    this.Encod.setValue(288, Float.valueOf(Vy), 21);
                    this.Encod.setValue(289, Float.valueOf(Vz), 21);
                    this.Encod.setValue(275, Float.valueOf(SoundVel), 21);
                    this.Encod.setValue(274, Float.valueOf(Alti), 11);
                    this.Encod.setValue(290, Float.valueOf(VxStd), 21);
                    this.Encod.setValue(291, Float.valueOf(VyStd), 21);
                    this.Encod.setValue(292, Float.valueOf(VzStd), 21);
                }
            }
        }
        return shift;
    }

    private int F_Process_ExtDvlWT(int DataID, byte[] Detected_Frame, int BlocStart, int shift) {
        double DvlTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
        int DvlId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
        float Vx = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 5, 1);
        float Vy = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 9, 1);
        float Vz = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 13, 1);
        float SoundVel = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 17, 1);
        float VxStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 21, 1);
        float VyStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 25, 1);
        float VzStd = this.Convert_4Bytes_to_Float(Detected_Frame, BlocStart + shift + 29, 1);
        shift += 33;
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(DataID);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(DvlTime, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(DvlId);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Vx, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Vy, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Vz, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SoundVel, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VxStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VyStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(VzStd, 3);
        this.InterpretedFrame = this.InterpretedFrame + "\n";
        if (this.GetCurvePlotImplementation()) {
            switch (DataID) {
                case 11: {
                    this.Encod.setValue(207, DvlId, 1000);
                    this.Encod.setValue(210, DvlTime, 31);
                    this.Encod.setValue(212, Float.valueOf(Vx), 21);
                    this.Encod.setValue(213, Float.valueOf(Vy), 21);
                    this.Encod.setValue(214, Float.valueOf(Vz), 21);
                    this.Encod.setValue(209, Float.valueOf(SoundVel), 21);
                    this.Encod.setValue(215, Float.valueOf(VxStd), 21);
                    this.Encod.setValue(216, Float.valueOf(VyStd), 21);
                    this.Encod.setValue(217, Float.valueOf(VzStd), 21);
                    break;
                }
                case 22: {
                    this.Encod.setValue(408, DvlId, 1000);
                    this.Encod.setValue(276, DvlTime, 31);
                    this.Encod.setValue(278, Float.valueOf(Vx), 21);
                    this.Encod.setValue(279, Float.valueOf(Vy), 21);
                    this.Encod.setValue(280, Float.valueOf(Vz), 21);
                    this.Encod.setValue(275, Float.valueOf(SoundVel), 21);
                    this.Encod.setValue(281, Float.valueOf(VxStd), 21);
                    this.Encod.setValue(282, Float.valueOf(VyStd), 21);
                    this.Encod.setValue(283, Float.valueOf(VzStd), 21);
                }
            }
        }
        return shift;
    }

    private int F_Process_EventsMarker(int DataID, int Version, byte[] Detected_Frame, int BlocStart, int shift) {
        double EventTime = (double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift, 1) * 1.0E-4;
        int EventId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + shift + 4, 1);
        long EventCount = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + shift + 5, 1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(DataID);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(EventTime, 8);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(EventId);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt((int)EventCount);
        this.InterpretedFrame = this.InterpretedFrame + "\n";
        System.out.println("Event " + this.InterpretIntegerAsInt(3) + this.InterpretIntegerAsInt(DataID) + this.InterpretDouble(EventTime, 8) + this.InterpretIntegerAsInt(EventId) + this.InterpretIntegerAsInt((int)EventCount) + "\n");
        if (this.GetCurvePlotImplementation()) {
            switch (DataID) {
                case 18: {
                    this.Encod.setValue(715, EventId, 1000);
                    this.Encod.setValue(716, EventTime, 31);
                    this.Encod.setValue(717, EventCount, 1000);
                    break;
                }
                case 19: {
                    this.Encod.setValue(718, EventId, 1000);
                    this.Encod.setValue(719, EventTime, 31);
                    this.Encod.setValue(720, EventCount, 1000);
                    break;
                }
                case 20: {
                    this.Encod.setValue(721, EventId, 1000);
                    this.Encod.setValue(722, EventTime, 31);
                    this.Encod.setValue(723, EventCount, 1000);
                }
            }
        }
        return shift;
    }
}

