/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;

public class IXSEA_TAH_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public IXSEA_TAH_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error" + sFrame_no_crlf);
            return -1;
        }
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!params[0].contentEquals("$PHOCT")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error" + sFrame_no_crlf);
            return -1;
        }
        if (params.length != 21) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error" + sFrame_no_crlf);
            return -1;
        }
        if (!params[1].contentEquals("01")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Version error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_tpt3(params[2])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTC Time error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_TE(params[3])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTC Time status error" + sFrame_no_crlf);
            return -1;
        }
        if (!params[4].contentEquals("03") && !params[4].contentEquals("25")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latency error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_ns_f3pt3(params[5])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " True Heading error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_TEI(params[6])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " True Heading status error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f3pt3(params[7])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_TEI(params[8])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll status error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f2pt3(params[9])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_TEI(params[10])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch status error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f2pt3(params[11])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heave without Prim.LVA error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_TEI(params[12])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " HSS status error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f2pt3(params[13])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heave error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f2pt3(params[14])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Surge error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f2pt3(params[15])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Sway error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f2pt3(params[16])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heave speed error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f2pt3(params[17])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Surge speed error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f2pt3(params[18])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Sway speed error" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_s_f4pt2(params[19])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading rate of turn error" + sFrame_no_crlf);
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(710, Float.valueOf(new Double(params[1]).floatValue()), 1000);
            this.Encod.setValue(100, Float.valueOf(new Double(params[2]).floatValue()), 34);
            this.Encod.setValue(1029, Integer.valueOf(params[3].charAt(0)), 1000);
            this.Encod.setValue(736, Integer.parseInt(params[4], 16), 1000);
            this.Encod.setValue(1025, Integer.valueOf(params[6].charAt(0)), 1000);
            this.Encod.setValue(1030, Integer.valueOf(params[12].charAt(0)), 1000);
            this.Encod.setValue(103, Float.valueOf(new Double(params[5]).floatValue()), 1);
            this.Encod.setValue(104, Float.valueOf(new Double(params[7]).floatValue()), 1);
            this.Encod.setValue(105, Float.valueOf(new Double(params[9]).floatValue()), 1);
            this.Encod.setValue(149, Float.valueOf(new Double(params[11]).floatValue()), 11);
            this.Encod.setValue(148, Float.valueOf(new Double(params[13]).floatValue()), 11);
            this.Encod.setValue(150, Float.valueOf(new Double(params[14]).floatValue()), 11);
            this.Encod.setValue(151, Float.valueOf(new Double(params[15]).floatValue()), 11);
            this.Encod.setValue(152, Float.valueOf(new Double(params[16]).floatValue()), 21);
            this.Encod.setValue(153, Float.valueOf(new Double(params[17]).floatValue()), 21);
            this.Encod.setValue(154, Float.valueOf(new Double(params[18]).floatValue()), 21);
            this.Encod.setValue(110, (double)new Double(params[19]).floatValue() / 60.0, 51);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

