/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import Protocols.CRC16Modbus;

public class LODESTAR_Msg03_Decoder
extends Decoder {
    private final Encoder Encod;
    public static final int DVL_MSG_LENGTH = 18;
    private double DvlRangeToBottom = 0.0;
    private double DvlTimeVal = 0.0;
    private double DvlEastSpeed = 0.0;
    private double DvlNorthSpeed = 0.0;
    private double DvlVerticalSpeed = 0.0;
    private int DvlStatus = 0;

    public LODESTAR_Msg03_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        byte[] Start2 = new byte[]{85};
        this.DecodeInit(0, 18, Start2, 1);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "DvlTimeVal(s)" + sep + "DvlEastSpeed(m/s)" + sep + "DvlNorthSpeed(m/s)" + sep + "DvlVerticalSpeed(m/s)" + sep + "DvlRangeToBottom(cm)" + sep + "DvlStatus(decimal)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        int i;
        int endianness = 0;
        CRC16Modbus crc2 = new CRC16Modbus();
        if (Detected_Frame[2] != 3) {
            this.InterpretedFrame = "Err DVL Message: Unexpected message ID.";
            return -1;
        }
        for (i = 3; i < 18; ++i) {
            if (Detected_Frame[i] != Detected_Frame[1]) continue;
            Detected_Frame[i] = 85;
        }
        int crc1 = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 16, endianness);
        crc2.reset();
        for (i = 2; i < 16; ++i) {
            crc2.update(Detected_Frame[i]);
        }
        if ((long)crc1 != crc2.getValue()) {
            this.InterpretedFrame = "Err DVL Message : Unexpected checksum";
            return -1;
        }
        this.DvlTimeVal = (double)(this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 3, endianness) * 1000000L) * 0.001;
        this.DvlEastSpeed = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 7, endianness) * 0.001;
        this.DvlNorthSpeed = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 9, endianness) * 0.001;
        this.DvlVerticalSpeed = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 11, endianness) * 0.001;
        this.DvlRangeToBottom = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 13, endianness) * 0.01;
        this.DvlStatus = Detected_Frame[15];
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(219, this.DvlTimeVal, 31);
            this.Encod.setValue(428, this.DvlEastSpeed, 21);
            this.Encod.setValue(427, this.DvlNorthSpeed, 21);
            this.Encod.setValue(429, this.DvlVerticalSpeed, 21);
            this.Encod.setValue(208, this.DvlRangeToBottom, 11);
            this.Encod.setValue(1001, this.DvlStatus, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretDouble(this.DvlTimeVal);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DvlEastSpeed);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DvlNorthSpeed);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DvlVerticalSpeed);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DvlRangeToBottom);
        this.InterpretedFrame = this.InterpretedFrame + this.DvlStatus;
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

