/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class LRS100_35_IC_Decoder
extends Decoder {
    private Encoder Encod;

    public LRS100_35_IC_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 4;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 90;
        Start_Blk[1] = -91;
        Start_Blk[2] = 29;
        Start_Blk[3] = 3;
        int Length_Blk = 35;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Sta1" + sep + "Sta2" + sep + "Heading(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "HeadingRate(rad/s)" + sep + "RollRate(rad/s)" + sep + "PitchRate(rad/s)" + sep + "NorthVel(m/s)" + sep + "EastVel(m/s)" + sep + "DownVel(m/s)" + sep + "NorthAcc(m/s2)" + sep + "EastAcc(m/s2)" + sep + "DownAcc(m/s2)";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        byte[] Chk = new byte[1];
        for (int i = 2; i < 33; ++i) {
            Chk[0] = (byte)(Chk[0] + this.Bytes_Frame[i]);
        }
        if (Chk[0] != this.Bytes_Frame[33]) {
            this.InterpretedFrame = this.InterpretString("Checksum error");
            return -1;
        }
        if (this.Bytes_Frame[34] != -86) {
            this.InterpretedFrame = this.InterpretString("End of frame error");
            return -1;
        }
        int Sta1 = this.Convert_1Byte_to_UnsignedInt(this.Bytes_Frame, 4, 1);
        int Sta2 = this.Convert_1Byte_to_UnsignedInt(this.Bytes_Frame, 5, 1);
        double Heading = (double)this.Convert_3Bytes_to_UnsignedInt(this.Bytes_Frame, 6, 1) * 180.0 / 8388608.0;
        double Roll = (double)this.Convert_3Bytes_to_SignedInt(this.Bytes_Frame, 9, 1) * 90.0 / 8388608.0;
        double Pitch = (double)this.Convert_3Bytes_to_SignedInt(this.Bytes_Frame, 12, 1) * 90.0 / 8388608.0;
        double HeadingRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 15, 1) * 1.0 / 32768.0;
        double RollRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 17, 1) * 1.0 / 32768.0;
        double PitchRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 19, 1) * 1.0 / 32768.0;
        double NorthVel = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 21, 1) * 65.536 / 32768.0;
        double EastVel = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 23, 1) * 65.536 / 32768.0;
        double DownVel = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 25, 1) * 65.536 / 32768.0;
        double NorthAcc = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 27, 1) * 327.68 / 32768.0;
        double EastAcc = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 29, 1) * 327.68 / 32768.0;
        double DownAcc = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 31, 1) * 327.68 / 32768.0;
        if (this.GetCurvePlotImplementation()) {
            int Status_Bite = Sta1 & 7;
            int Status_Mode = Sta1 & 0x18;
            int Status_HRPVal = Sta1 & 0x60;
            int Status_GpsTimeVal = Sta2 & 1;
            int Status_Navigation = Sta2 & 0x10;
            int Status_Simulation = Sta2 & 0x40;
            this.Encod.setValue(1023, Status_Bite, 1000);
            this.Encod.setValue(1024, Status_Mode, 1000);
            this.Encod.setValue(1025, Status_HRPVal, 1000);
            this.Encod.setValue(1026, Status_GpsTimeVal, 1000);
            this.Encod.setValue(1004, Status_Simulation, 1000);
            this.Encod.setValue(1027, Status_Navigation, 1000);
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            this.Encod.setValue(104, Float.valueOf((float)Roll), 1);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 1);
            this.Encod.setValue(110, Float.valueOf((float)HeadingRate), 52);
            this.Encod.setValue(111, Float.valueOf((float)RollRate), 52);
            this.Encod.setValue(112, Float.valueOf(-((float)PitchRate)), 52);
            this.Encod.setValue(136, Float.valueOf((float)NorthVel), 21);
            this.Encod.setValue(137, Float.valueOf((float)EastVel), 21);
            this.Encod.setValue(138, Float.valueOf(-((float)DownVel)), 21);
            this.Encod.setValue(335, Float.valueOf((float)NorthAcc), 43);
            this.Encod.setValue(336, Float.valueOf((float)EastAcc), 43);
            this.Encod.setValue(337, Float.valueOf(-((float)DownAcc)), 43);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretIntegerAsBin(Sta1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsBin(Sta2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(HeadingRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(RollRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(PitchRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(NorthVel);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(EastVel);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(DownVel);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(NorthAcc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(EastAcc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(DownAcc);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

