/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;
import java.util.regex.Matcher;

public class OCTANS_STANDARD_Decoder
extends Decoder {
    private Encoder Encod;
    private String heading = "0";
    private String PHTRO_roll = "0";
    private String PHTRO_pitch = "0";
    private String PHTRO_roll_sign = "0";
    private String PHTRO_pitch_sign = "0";
    private String PHLIN_surge = "0";
    private String PHLIN_sway = "0";
    private String PHLIN_heave = "0";
    private String PHSPD_surge_speed = "0";
    private String PHSPD_sway_speed = "0";
    private String PHSPD_heave_speed = "0";
    private String PHINF_user_status;
    double PHCMP_latitude = 0.0;
    private String PHCMP_speed_over_ground = "0";

    public OCTANS_STANDARD_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList("NMEA checksum error : " + sFrame_no_crlf);
            return -1;
        }
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        switch (params[0]) {
            case "$HEHDT": {
                if (params.length != 4) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!params[2].contentEquals("T")) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (params[1].isEmpty()) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!RegExp.is_ns_fpt2fpt5(params[1])) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (this.GetCurvePlotImplementation()) {
                    this.heading = params[1];
                }
                this.InterpretedFrame_AddToList(sFrame_no_crlf);
                break;
            }
            case "$HETHS": {
                if (params.length != 4) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!RegExp.is_AEMSV(params[2])) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (params[1].isEmpty()) {
                    params[1] = "0";
                } else if (!RegExp.is_ns_fpt2fpt5(params[1])) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error :" + sFrame_no_crlf);
                    return -1;
                }
                if (this.GetCurvePlotImplementation()) {
                    this.heading = params[1];
                }
                this.InterpretedFrame_AddToList(sFrame_no_crlf);
                break;
            }
            case "$PHTRO": {
                if (params.length != 6) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!(RegExp.is_ns_fpt2(params[1]) && RegExp.is_MP(params[2]) && RegExp.is_ns_fpt2(params[3]) && RegExp.is_BT(params[4]))) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (this.GetCurvePlotImplementation()) {
                    this.PHTRO_pitch = params[1];
                    this.PHTRO_pitch_sign = params[2];
                    this.PHTRO_roll = params[3];
                    this.PHTRO_roll_sign = params[4];
                }
                this.InterpretedFrame_AddToList(sFrame_no_crlf);
                break;
            }
            case "$PHLIN": {
                if (params.length != 5) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!(RegExp.is_fpt3(params[1]) && RegExp.is_fpt3(params[2]) && RegExp.is_fpt3(params[3]))) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (this.GetCurvePlotImplementation()) {
                    this.PHLIN_surge = params[1];
                    this.PHLIN_sway = params[2];
                    this.PHLIN_heave = params[3];
                }
                this.InterpretedFrame_AddToList(sFrame_no_crlf);
                break;
            }
            case "$PHSPD": {
                if (params.length != 5) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!(RegExp.is_fpt3(params[1]) && RegExp.is_fpt3(params[2]) && RegExp.is_fpt3(params[3]))) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (this.GetCurvePlotImplementation()) {
                    this.PHSPD_surge_speed = params[1];
                    this.PHSPD_sway_speed = params[2];
                    this.PHSPD_heave_speed = params[3];
                }
                this.InterpretedFrame_AddToList(sFrame_no_crlf);
                break;
            }
            case "$PHCMP": {
                if (params.length != 6) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!params[4].matches("N")) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!RegExp.is_fpt2(params[3])) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                Matcher m = RegExp.ptn_d2_ns_f2pt2.matcher(params[1]);
                if (!m.matches()) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!RegExp.is_NS(params[2])) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (this.GetCurvePlotImplementation()) {
                    this.PHCMP_latitude = (double)Integer.parseInt(m.group(1)) + Double.parseDouble(m.group(2)) / 60.0;
                    if (params[2].matches("S")) {
                        this.PHCMP_latitude = -this.PHCMP_latitude;
                    }
                    this.PHCMP_speed_over_ground = params[3];
                }
                this.InterpretedFrame_AddToList(sFrame_no_crlf);
                break;
            }
            case "$PHINF": {
                if (params.length != 3) {
                    this.InterpretedFrame_AddToList(params[0] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (!RegExp.is_hexa8(params[1])) {
                    this.InterpretedFrame_AddToList(params[1] + " Format error : " + sFrame_no_crlf);
                    return -1;
                }
                if (this.GetCurvePlotImplementation()) {
                    this.PHINF_user_status = params[1];
                    this.Encod.setValue(103, Float.valueOf(new Double(this.heading).floatValue()), 1);
                    if (this.PHTRO_pitch_sign.matches("M")) {
                        this.Encod.setValue(105, Float.valueOf(-new Double(this.PHTRO_pitch).floatValue()), 1);
                    } else {
                        this.Encod.setValue(105, Float.valueOf(new Double(this.PHTRO_pitch).floatValue()), 1);
                    }
                    if (this.PHTRO_roll_sign.matches("B")) {
                        this.Encod.setValue(104, Float.valueOf(-new Double(this.PHTRO_roll).floatValue()), 1);
                    } else {
                        this.Encod.setValue(104, Float.valueOf(new Double(this.PHTRO_roll).floatValue()), 1);
                    }
                    this.Encod.setValue(150, Float.valueOf(new Double(this.PHLIN_surge).floatValue()), 11);
                    this.Encod.setValue(151, Float.valueOf(new Double(this.PHLIN_sway).floatValue()), 11);
                    this.Encod.setValue(148, Float.valueOf(new Double(this.PHLIN_heave).floatValue()), 11);
                    this.Encod.setValue(153, Float.valueOf(new Double(this.PHSPD_surge_speed).floatValue()), 21);
                    this.Encod.setValue(154, Float.valueOf(new Double(this.PHSPD_sway_speed).floatValue()), 21);
                    this.Encod.setValue(152, Float.valueOf(new Double(this.PHSPD_heave_speed).floatValue()), 21);
                    this.Encod.setValue(124, Float.valueOf(new Double(this.PHCMP_latitude).floatValue()), 1);
                    this.Encod.setValue(146, Float.valueOf(new Double(this.PHCMP_speed_over_ground).floatValue()), 25);
                    this.Encod.setValue(610, this.PHINF_user_status, 1000);
                    LoggerDecoderFrame.FrameReady = true;
                }
                this.InterpretedFrame_AddToList(sFrame_no_crlf);
                break;
            }
            default: {
                this.InterpretedFrame_AddToList("Unexpected header : " + sFrame_no_crlf);
                return -1;
            }
        }
        return 0;
    }
}

