/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class PEGASE_CMS_Decoder
extends Decoder {
    private Encoder Encod;

    public PEGASE_CMS_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 3;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 0;
        Start_Blk[1] = 0;
        Start_Blk[2] = 0;
        int Length_Blk = 56;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "BlockValidity" + sep + "Heading(\u00b0)" + sep + "EMLog Speed(m/s)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Latitude(\u00b0)" + sep + "Longitude(\u00b0)" + sep + "Depth(m)" + sep + "XV1RotRate(\u00b0/s)" + sep + "XV2RotRate(\u00b0/s)" + sep + "XV3RotRate(\u00b0/s)" + sep + "XV1Speed(m/s)";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        boolean block_notvalid = false;
        if (this.Bytes_Frame[3] == 0) {
            block_notvalid = true;
        }
        long blkval = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 0, 1);
        float heading = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 4, 1) * 0.01);
        float emlogspeed = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 8, 1) * 0.01);
        float roll = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 12, 1) * 0.01);
        float pitch = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 16, 1) * 0.01);
        double latitude = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 20, 1) * 0.01 / 3600.0);
        double longitude = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 24, 1) * 0.01 / 3600.0);
        boolean error = false;
        for (int j = 32; j < 40; ++j) {
            if (this.Bytes_Frame[j] == 0) continue;
            error = true;
        }
        float xv1rate = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 40, 1) * 0.5);
        float xv2rate = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 44, 1) * 0.5);
        float xv3rate = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 48, 1) * 0.5);
        float xv1speed = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 52, 1) * 0.01);
        if (error) {
            this.InterpretedFrame = this.InterpretString("ERROR");
            return 0;
        }
        this.InterpretedFrame = this.InterpretIntegerAsInt((int)blkval);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(heading, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(emlogspeed, 241);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(latitude, 124);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(longitude, 125);
        float fDepth = 0.0f;
        long lDepth = 0L;
        if (!block_notvalid) {
            fDepth = (float)((double)this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 28, 1) * 0.01);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(fDepth, 126);
        } else {
            lDepth = this.Convert_4Bytes_to_UnsignedInt(this.Bytes_Frame, 28, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)lDepth);
        }
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(xv1rate, 114);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(xv2rate, 115);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(xv3rate, 116);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(xv1speed, 133);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(103, Float.valueOf(heading), 1);
            this.Encod.setValue(104, Float.valueOf(-roll), 1);
            this.Encod.setValue(105, Float.valueOf(pitch), 1);
            this.Encod.setValue(241, Float.valueOf(emlogspeed), 21);
            this.Encod.setValue(124, latitude, 1);
            this.Encod.setValue(125, longitude, 1);
            if (!block_notvalid) {
                this.Encod.setValue(126, Float.valueOf(fDepth), 11);
            } else {
                this.Encod.setValue(126, lDepth, 11);
            }
            this.Encod.setValue(114, Float.valueOf(-xv1rate), 51);
            this.Encod.setValue(115, Float.valueOf(xv2rate), 51);
            this.Encod.setValue(116, Float.valueOf(-xv3rate), 51);
            this.Encod.setValue(133, Float.valueOf(xv1speed), 51);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

