/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;

public class PRDID_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public PRDID_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.current_line = 0;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        String ProtocolName = this.Info.GetProtocolName();
        ++this.current_line;
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
            return -1;
        }
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!params[0].contentEquals("$PRDID")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error");
            return -1;
        }
        if (params.length != 5) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        if (!RegExp.is_s_f3pt2(params[1])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch format error");
            return -1;
        }
        if (!RegExp.is_s_f3pt2(params[2])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll format error");
            return -1;
        }
        if (!RegExp.is_ns_f3pt2(params[3])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading format error");
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(105, Float.valueOf(-new Double(params[1]).floatValue()), 1);
            if (ProtocolName.matches("PRDID_TSS")) {
                this.Encod.setValue(412, Float.valueOf(new Double(params[2]).floatValue()), 1);
            } else {
                this.Encod.setValue(104, Float.valueOf(new Double(params[2]).floatValue()), 1);
            }
            this.Encod.setValue(103, Float.valueOf(new Double(params[3]).floatValue()), 1);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

