/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PTNL_GGK_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public PTNL_GGK_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        Pattern p;
        int Year;
        int Month;
        int Day;
        Matcher m;
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
            return -1;
        }
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!params[0].contentEquals("$PTNL") || !params[1].contentEquals("GGK")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error:" + sFrame_no_crlf);
            return -1;
        }
        if (params.length != 14) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_tpt2(params[2])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTC Time format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!params[3].contentEquals("")) {
            m = RegExp.is_ddmmyy(params[3]);
            if (!m.matches()) {
                this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTC Date format error:" + sFrame_no_crlf);
                return -1;
            }
            Day = Integer.parseInt(m.group(1));
            Month = Integer.parseInt(m.group(2));
            Year = Integer.parseInt(m.group(3));
        } else {
            Day = 0;
            Month = 0;
            Year = 0;
        }
        m = RegExp.is_d2_ns_f2pt7(params[4]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latitude format error:" + sFrame_no_crlf);
            return -1;
        }
        double Latitude = (double)Integer.parseInt(m.group(1)) + Double.parseDouble(m.group(2)) / 60.0;
        if (!RegExp.is_NS(params[5])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Latitude sign format error:" + sFrame_no_crlf);
            return -1;
        }
        if (params[5].contentEquals("S")) {
            Latitude = -Latitude;
        }
        if (!(m = RegExp.is_d3_ns_f2pt7(params[6])).matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Longitude format error:" + sFrame_no_crlf);
            return -1;
        }
        double Longitude = (double)Integer.parseInt(m.group(1)) + Double.parseDouble(m.group(2)) / 60.0;
        if (!RegExp.is_EW(params[7])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Longitude sign format error:" + sFrame_no_crlf);
            return -1;
        }
        if (params[7].contentEquals("W")) {
            Longitude = -Longitude;
        }
        if (!(m = (p = Pattern.compile("(^[0-6]{1})")).matcher(params[8])).matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " GPS Quality format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_d2(params[9])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Number of satellites format error:" + sFrame_no_crlf);
            return -1;
        }
        if (!RegExp.is_fpt(params[10])) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " HDOP format error:" + sFrame_no_crlf);
            return -1;
        }
        p = Pattern.compile("(EHT)([-]?[0-9]+\\.[0-9]{3})");
        m = p.matcher(params[11]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Altitude format error:" + sFrame_no_crlf);
            return -1;
        }
        String sAlti = m.group(2);
        double Altitude = Float.parseFloat(sAlti);
        p = Pattern.compile("M");
        m = p.matcher(params[12]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Altitude unit format error:" + sFrame_no_crlf);
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(100, Float.valueOf(new Double(params[2]).floatValue()), 34);
            this.Encod.setValue(155, Day, 1000);
            this.Encod.setValue(156, Month, 1000);
            this.Encod.setValue(157, Year, 1000);
            this.Encod.setValue(124, Float.valueOf((float)Latitude), 1);
            this.Encod.setValue(125, Float.valueOf((float)Longitude), 1);
            this.Encod.setValue(126, Float.valueOf((float)Altitude), 11);
            this.Encod.setValue(726, Float.valueOf(new Double(params[8]).floatValue()), 1000);
            this.Encod.setValue(727, Float.valueOf(new Double(params[9]).floatValue()), 1000);
            this.Encod.setValue(728, Float.valueOf(new Double(params[10]).floatValue()), 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

