/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class RSTA_RCS_Decoder
extends Decoder {
    private Encoder Encod;
    float Latitude;
    float Longitude;
    float Altitude;
    float Heading;
    float Roll;
    float Pitch;
    float Course;
    float GroundSpeed;
    float UpSpeed;
    float Latitude_Std;
    float Longitude_Std;
    float Altitude_Std;
    float Heading_Std;
    float Roll_Std;
    float Pitch_Std;
    float GroundSpeed_Std;
    float UpSpeed_Std;
    public static final int DATABLOCK_LENGTH = 70;
    public static final int POSITION_COMMAND_ID = 5;
    public static final int ATTITUDE_COMMAND_ID = 6;
    public static final int TRACK_COMMAND_ID = 7;

    public RSTA_RCS_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 126;
        this.DecodeInit(0, 70, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "RSTA_RCS" + sep + "Lat(\u00b0)" + sep + "Long(\u00b0)" + sep + "Alt(m)" + sep + "Head(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Course(\u00b0)" + sep + "GroundSpd(m/s)" + sep + "UpSpd(m/s)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        boolean EndOfFrame = false;
        int Command_Id = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 1, 1);
        long Time = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 3, 1);
        Time = (long)Math.pow(2.0, 32.0) - Time - 1L;
        switch (Command_Id) {
            case 5: {
                this.Latitude = this.FixedPointToFloat((int)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 7, 1), 23);
                this.Longitude = this.FixedPointToFloat((int)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 11, 1), 23);
                this.Altitude = this.FixedPointToFloat((int)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 15, 1), 15);
                this.Latitude_Std = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 19, 1), 7);
                this.Longitude_Std = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 21, 1), 7);
                this.Altitude_Std = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 23, 1), 7);
                if (!this.GetCurvePlotImplementation()) break;
                this.Encod.setValue(124, Float.valueOf(this.Latitude), 1);
                this.Encod.setValue(125, Float.valueOf(this.Longitude), 1);
                this.Encod.setValue(126, Float.valueOf(this.Altitude), 11);
                this.Encod.setValue(129, Float.valueOf(this.Latitude_Std), 11);
                this.Encod.setValue(130, Float.valueOf(this.Longitude_Std), 11);
                this.Encod.setValue(131, Float.valueOf(this.Altitude_Std), 11);
                break;
            }
            case 6: {
                this.Heading = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 7, 1), 7);
                this.Roll = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 11, 1), 7);
                this.Pitch = -this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 9, 1), 7);
                this.Heading_Std = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 13, 1), 7);
                this.Roll_Std = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 17, 1), 7);
                this.Pitch_Std = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 15, 1), 7);
                if (!this.GetCurvePlotImplementation()) break;
                this.Encod.setValue(103, Float.valueOf(this.Heading), 1);
                this.Encod.setValue(104, Float.valueOf(this.Roll), 1);
                this.Encod.setValue(105, Float.valueOf(this.Pitch), 1);
                this.Encod.setValue(107, Float.valueOf(this.Heading_Std), 1);
                this.Encod.setValue(108, Float.valueOf(this.Roll_Std), 1);
                this.Encod.setValue(109, Float.valueOf(this.Pitch_Std), 1);
                break;
            }
            case 7: {
                this.Course = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 7, 1), 7);
                this.GroundSpeed = this.FixedPointToFloat((int)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 9, 1), 15);
                this.UpSpeed = this.FixedPointToFloat((int)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 13, 1), 15);
                this.GroundSpeed_Std = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 17, 1), 12);
                this.UpSpeed_Std = this.FixedPointToFloat((short)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 19, 1), 12);
                if (this.GetCurvePlotImplementation()) {
                    this.Encod.setValue(100, Time, 31);
                    this.Encod.setValue(147, Float.valueOf(this.Course), 1);
                    this.Encod.setValue(146, Float.valueOf(this.GroundSpeed), 21);
                    this.Encod.setValue(141, Float.valueOf(this.GroundSpeed_Std), 21);
                    this.Encod.setValue(138, Float.valueOf(this.UpSpeed), 21);
                    this.Encod.setValue(143, Float.valueOf(this.UpSpeed_Std), 21);
                }
                EndOfFrame = true;
            }
        }
        if (EndOfFrame) {
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretString("RSTA_RCS");
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Latitude, 124);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Longitude, 125);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Altitude, 126);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Heading, 103);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Roll, 104);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Pitch, 105);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.Course, 147);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.GroundSpeed, 146);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.UpSpeed, 138);
            if (this.GetCurvePlotImplementation()) {
                LoggerDecoderFrame.FrameReady = true;
            }
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }

    public float FixedPointToFloat(int _l, int iFixedPoint_Quantif) {
        return (float)((double)_l * Math.pow(2.0, -iFixedPoint_Quantif));
    }
}

