/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class RTCM_SIX_Decoder
extends Decoder {
    public static final int PVT_BLOCK_LENGTH = 53;
    public static final int PVTCOV_BLOCK_LENGTH = 65;
    private Covariance PositionCov;
    private Covariance SpeedCov;
    private Covariance DeltaCov;
    private Encoder Encod;

    public RTCM_SIX_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 3;
        byte[] Start_Blk_n1 = new byte[Start_Blk_Length];
        byte[] Start_Blk_n2 = new byte[Start_Blk_Length];
        Start_Blk_n1[0] = -45;
        Start_Blk_n1[1] = 0;
        Start_Blk_n1[2] = 53;
        Start_Blk_n2[0] = -45;
        Start_Blk_n2[1] = 0;
        Start_Blk_n2[2] = 65;
        this.DecodeInit(0, 59, Start_Blk_n1, Start_Blk_Length);
        this.DecodeInit(0, 71, Start_Blk_n2, Start_Blk_Length);
        this.PositionCov = new Covariance();
        this.SpeedCov = new Covariance();
        this.DeltaCov = new Covariance();
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "TOW" + sep + "WnC" + sep + "Status" + sep + "X (m)" + sep + "Y (m)" + sep + "Z (m)" + sep + "Datum" + sep + "VX (m/s)" + sep + "VY (m/s)" + sep + "VZ (m/s)" + sep + "DTOW" + sep + "DX (m)" + sep + "DY (m)" + sep + "DZ (m)" + sep + "SimgaPxPx (m)" + sep + "SimgaPyPy (m)" + sep + "SimgaPzPz (m)" + sep + "RhoPxPy" + sep + "RhoPxPz" + sep + "RhoPyPz" + sep + "SimgaVxVx (m/s)" + sep + "SimgaVyVy (m/s)" + sep + "SigmaVzVz (m/s)" + sep + "RhoVxVy" + sep + "RhoVxVz" + sep + "RhoVyVz" + sep + "SimgaDxDx (m)" + sep + "SimgaDyDy (m/s)" + sep + "SigmaDzDz (m/s)" + sep + "RhoDxDy" + sep + "RhoDxDz" + sep + "RhoDyDz";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        if (Detected_Frame[2] == 53) {
            long TOW = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 6, 1);
            this.InterpretedFrame = this.InterpretDouble(0.001 * (double)TOW, 3);
            int WnC = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 10, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(WnC);
            int Status = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 12, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Status);
            long PosX = this.Convert_5Bytes_to_SignedInt(Detected_Frame, 14, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(1.0E-4 * (double)PosX, 4);
            long PosY = this.Convert_5Bytes_to_SignedInt(Detected_Frame, 19, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(1.0E-4 * (double)PosY, 4);
            long PosZ = this.Convert_5Bytes_to_SignedInt(Detected_Frame, 24, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(1.0E-4 * (double)PosZ, 4);
            byte Datum = Detected_Frame[29];
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Datum);
            long VX = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 30, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(1.0E-4 * (double)VX, 4);
            long VY = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 34, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(1.0E-4 * (double)VY, 4);
            long VZ = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 38, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(1.0E-4 * (double)VZ, 4);
            int DTOW = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 42, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(0.001 * (double)DTOW, 3);
            long DX = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 44, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(1.0E-4 * (double)DX, 4);
            long DY = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 48, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(1.0E-4 * (double)DY, 4);
            long DZ = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 52, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(1.0E-4 * (double)DZ, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.PositionCov.SigmaXX, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.PositionCov.SigmaYY, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.PositionCov.SigmaZZ, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.PositionCov.RhoXY, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.PositionCov.RhoXZ, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.PositionCov.RhoYZ, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.SpeedCov.SigmaXX, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.SpeedCov.SigmaYY, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.SpeedCov.SigmaZZ, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.SpeedCov.RhoXY, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.SpeedCov.RhoXZ, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.SpeedCov.RhoYZ, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DeltaCov.SigmaXX, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DeltaCov.SigmaYY, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DeltaCov.SigmaZZ, 4);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DeltaCov.RhoXY, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DeltaCov.RhoXZ, 6);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(this.DeltaCov.RhoYZ, 6);
            int CRC = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 56, 1);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(CRC);
            this.InterpretedFrame_AddToList(this.InterpretedFrame);
        } else {
            this.PositionCov.SigmaXX = 1.0E-4 * (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 14, 1);
            this.PositionCov.SigmaYY = 1.0E-4 * (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 17, 1);
            this.PositionCov.SigmaZZ = 1.0E-4 * (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 20, 1);
            this.PositionCov.RhoXY = 1.0E-6 * (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 23, 1);
            this.PositionCov.RhoXZ = 1.0E-6 * (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 26, 1);
            this.PositionCov.RhoYZ = 1.0E-6 * (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 29, 1);
            this.SpeedCov.SigmaXX = 1.0E-4 * (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 32, 1);
            this.SpeedCov.SigmaYY = 1.0E-4 * (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 35, 1);
            this.SpeedCov.SigmaZZ = 1.0E-4 * (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 38, 1);
            this.SpeedCov.RhoXY = 1.0E-6 * (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 41, 1);
            this.SpeedCov.RhoXZ = 1.0E-6 * (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 44, 1);
            this.SpeedCov.RhoYZ = 1.0E-6 * (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 47, 1);
            this.DeltaCov.SigmaXX = 1.0E-4 * (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 50, 1);
            this.DeltaCov.SigmaYY = 1.0E-4 * (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 53, 1);
            this.DeltaCov.SigmaZZ = 1.0E-4 * (double)this.Convert_3Bytes_to_UnsignedInt(Detected_Frame, 56, 1);
            this.DeltaCov.RhoXY = 1.0E-6 * (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 59, 1);
            this.DeltaCov.RhoXZ = 1.0E-6 * (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 62, 1);
            this.DeltaCov.RhoYZ = 1.0E-6 * (double)this.Convert_3Bytes_to_SignedInt(Detected_Frame, 65, 1);
        }
        return 0;
    }

    class Covariance {
        public double SigmaXX = 0.0;
        public double SigmaYY = 0.0;
        public double SigmaZZ = 0.0;
        public double RhoXY = 0.0;
        public double RhoXZ = 0.0;
        public double RhoYZ = 0.0;

        Covariance() {
        }
    }
}

