/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class SEANAV_ID1_Decoder
extends Decoder {
    private Encoder Encod;

    public SEANAV_ID1_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 3;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = -86;
        Start_Blk[1] = 1;
        Start_Blk[2] = 52;
        int Length_Blk = 56;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "TRCounter" + sep + "Status1" + sep + "Status2(bin)" + sep + "Lat(deg)" + sep + "Long(deg)" + sep + "Depth(cm)" + sep + "Day" + sep + "Month" + sep + "Year(-1970)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Heading(\u00b0)" + sep + "XV1_vel(m/s)" + sep + "XV2_vel(m/s)" + sep + "XV3_vel(m/s)" + sep + "XV1_acc(m/s2)" + sep + "XV2_acc(m/s2)" + sep + "XV3_acc(m/s2)" + sep + "Roll_rate(rad/s)" + sep + "Pitch_rate(rad/s)" + sep + "Heading_rate(rad/s)" + sep + "Time b31" + sep + "Time(sec)" + sep + "Surge(m)" + sep + "Sway(m)" + sep + "Heave(m)";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sep = this.Info.GetSeparator();
        byte[] Chk = new byte[1];
        boolean error = false;
        Chk[0] = 0;
        for (int i = 1; i < 55; ++i) {
            Chk[0] = (byte)(Chk[0] ^ this.Bytes_Frame[i]);
        }
        if (Chk[0] != this.Bytes_Frame[55]) {
            error = true;
        }
        if (error) {
            this.InterpretedFrame = this.InterpretString("Checksum error");
            return 0;
        }
        int TRcnt = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 3, 0);
        int Status1 = this.Convert_1Byte_to_UnsignedInt(this.Bytes_Frame, 5, 0);
        int Status2 = this.Convert_1Byte_to_UnsignedInt(this.Bytes_Frame, 6, 0);
        float Lat = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 7, 0) * 180.0 / Math.pow(2.0, 31.0));
        float Long2 = (float)((double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 11, 0) * 180.0 / Math.pow(2.0, 31.0));
        float Alt = -this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 15, 0);
        int Date2 = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 19, 0);
        int Day = Date2 & 0x1F;
        int Month = (Date2 & 0x1E0) >> 5;
        int Year = (Date2 & 0xFE00) >> 9;
        float Roll = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 21, 0) * 180.0 / Math.pow(2.0, 15.0));
        float Pitch = -((float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 23, 0) * 180.0 / Math.pow(2.0, 15.0)));
        float Heading = (float)((double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 25, 0) * 180.0 / Math.pow(2.0, 15.0));
        float XV1_vel = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 27, 0) * 32.0 / Math.pow(2.0, 15.0));
        float XV2_vel = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 29, 0) * 32.0 / Math.pow(2.0, 15.0));
        float XV3_vel = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 31, 0) * 32.0 / Math.pow(2.0, 15.0));
        float XV1_acc = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 33, 0) * 32.0 / Math.pow(2.0, 15.0));
        float XV2_acc = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 35, 0) * 32.0 / Math.pow(2.0, 15.0));
        float XV3_acc = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 37, 0) * 32.0 / Math.pow(2.0, 15.0));
        float Roll_rate = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 39, 0) * 4.0 / Math.pow(2.0, 15.0));
        float Pitch_rate = -((float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 41, 0) * 4.0 / Math.pow(2.0, 15.0)));
        float Heading_rate = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 43, 0) * 4.0 / Math.pow(2.0, 15.0));
        int FieldTime = this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 45, 0) & Integer.MAX_VALUE;
        int MSBFieldTime = this.Convert_1Byte_to_SignedInt(this.Bytes_Frame, 48, 0) & 0x80;
        float Time = (float)((double)FieldTime * 1.0 / Math.pow(2.0, 14.0));
        float Surge = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 49, 0) * 64.0 / Math.pow(2.0, 15.0));
        float Sway = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 51, 0) * 64.0 / Math.pow(2.0, 15.0));
        float Heave = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 53, 0) * 64.0 / Math.pow(2.0, 15.0));
        this.InterpretedFrame = this.InterpretIntegerAsInt(TRcnt);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Status1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsBin(Status2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 124);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2, 125);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Alt, 126);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Day);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Month);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Year);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV1_vel, 136);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV2_vel, 137);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV3_vel, 138);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV1_acc, 309);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV2_acc, 310);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV3_acc, 311);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll_rate, 111);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch_rate, 112);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading_rate, 110);
        this.InterpretedFrame = MSBFieldTime == 128 ? this.InterpretedFrame + '1' : this.InterpretedFrame + '0';
        this.InterpretedFrame = this.InterpretedFrame + sep;
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time, 100);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Surge, 150);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Sway, 151);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heave, 148);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(100, Float.valueOf(Time), 31);
            this.Encod.setValue(155, Day, 1000);
            this.Encod.setValue(156, Month, 1000);
            this.Encod.setValue(157, Year + 1970, 1000);
            this.Encod.setValue(1003, Status1, 1000);
            this.Encod.setValue(1027, Status2, 1000);
            this.Encod.setValue(124, Float.valueOf(Lat), 1);
            this.Encod.setValue(125, Float.valueOf(Long2), 1);
            this.Encod.setValue(126, Float.valueOf(Alt), 15);
            this.Encod.setValue(103, Float.valueOf(Heading), 1);
            this.Encod.setValue(104, Float.valueOf(Roll), 1);
            this.Encod.setValue(105, Float.valueOf(Pitch), 1);
            this.Encod.setValue(133, Float.valueOf(XV1_vel), 21);
            this.Encod.setValue(134, Float.valueOf(XV2_vel), 21);
            this.Encod.setValue(135, Float.valueOf(XV3_vel), 21);
            this.Encod.setValue(121, Float.valueOf(XV1_acc), 43);
            this.Encod.setValue(122, Float.valueOf(XV2_acc), 43);
            this.Encod.setValue(123, Float.valueOf(XV3_acc), 43);
            this.Encod.setValue(110, Float.valueOf(Heading_rate), 52);
            this.Encod.setValue(111, Float.valueOf(Roll_rate), 52);
            this.Encod.setValue(112, Float.valueOf(Pitch_rate), 52);
            this.Encod.setValue(148, Float.valueOf(Heave), 11);
            this.Encod.setValue(150, Float.valueOf(Surge), 11);
            this.Encod.setValue(151, Float.valueOf(Sway), 11);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

