/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import RegExp.RegExp;

public class SIGRS1_Decoder
extends Decoder {
    private Encoder Encod;
    private double UtcTime = 0.0;
    private String Heading = "0";
    private String Roll = "0";
    private String Pitch = "0";
    private String Latitude = "0";
    private String Longitude = "0";
    private String Altitude = "0";
    private String HorizontalSpeed = "0";
    private String REP_StatusOptimalNav = "0";
    private String REP_UpdateCmdAns = "0";
    private String REP_ModeCmdAns = "0";
    private String NV1_StatusSensorList = "0";
    private String NV1_SystemTime = "0";
    private String NV1_StatusActiveMode = "0";
    private String NV1_StatusFailureReport = "0";
    private String NV1_DistanceTravelled = "0";
    private String NV1_HeadingSD = "0";
    private String NV1_PositionSD = "0";
    private String NV1_GPSSatNb = "0";
    private String NV1_GPSHdop = "0";
    private String NV2_ElapsedTime = "0";
    private String NV2_RemainAlignTime = "0";
    private String NV2_AnsToCdiCmd = "0";
    private String NV2_CdiCmd = "0";
    private String NV2_CdiData = "0";
    private String NV2_LatitudeSD = "0";
    private String NV2_LongitudeSD = "0";
    private String NV2_AltitudeSD = "0";
    private String NV3_UtcHours = "0";
    private String NV3_UtcMinutes = "0";
    private String NV3_UtcSeconds = "0";
    private String NV3_GpsLatitude = "0";
    private String NV3_GpsLongitude = "0";
    private String NV3_GpsAltitude = "0";
    private String NV3_GpsValidity = "0";
    private String NV3_GpsMode = "0";

    public SIGRS1_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        return " ";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(sFrame_no_crlf + " NMEA checksum error");
            return -1;
        }
        if (params[0].contentEquals("$PCATT")) {
            if (params.length != 6) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Format error");
                return -1;
            }
            if (!params[1].contentEquals("01")) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Version error");
                return -1;
            }
            if (!RegExp.is_ns_f3pt4(params[2])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Heading format error");
                return -1;
            }
            if (!RegExp.is_s_f3pt4(params[3])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Roll format error");
                return -1;
            }
            if (!RegExp.is_s_f2pt4(params[4])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Pitch format error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.Heading = params[2];
                this.Roll = params[3];
                this.Pitch = params[4];
                this.Encod.setValue(103, Float.valueOf(new Double(this.Heading).floatValue()), 1);
                this.Encod.setValue(104, Float.valueOf(new Double(this.Roll).floatValue()), 1);
                this.Encod.setValue(105, Float.valueOf(-new Double(this.Pitch).floatValue()), 1);
                this.Encod.setValue(124, Float.valueOf(new Double(this.Latitude).floatValue()), 1);
                this.Encod.setValue(125, Float.valueOf(new Double(this.Longitude).floatValue()), 1);
                this.Encod.setValue(126, Float.valueOf(new Double(this.Altitude).floatValue()), 11);
                this.Encod.setValue(146, Float.valueOf(new Double(this.HorizontalSpeed).floatValue()), 21);
                this.Encod.setValue(1032, this.REP_StatusOptimalNav, 1000);
                this.Encod.setValue(776, this.REP_UpdateCmdAns, 1000);
                this.Encod.setValue(777, this.REP_ModeCmdAns, 1000);
                this.Encod.setValue(1031, this.NV1_StatusSensorList, 1000);
                this.Encod.setValue(1024, this.NV1_StatusActiveMode, 1000);
                this.Encod.setValue(1022, this.NV1_StatusFailureReport, 1000);
                this.Encod.setValue(101, this.NV1_SystemTime, 31);
                this.Encod.setValue(265, Float.valueOf(new Double(this.NV1_DistanceTravelled).floatValue()), 11);
                this.Encod.setValue(126, Float.valueOf(new Double(this.Altitude).floatValue()), 11);
                this.Encod.setValue(107, Float.valueOf(new Double(this.NV1_HeadingSD).floatValue()), 1);
                this.Encod.setValue(129, Float.valueOf(new Double(this.NV1_PositionSD).floatValue()), 11);
                this.Encod.setValue(769, Float.valueOf(new Double(this.NV1_GPSSatNb).floatValue()), 1000);
                this.Encod.setValue(770, Float.valueOf(new Double(this.NV1_GPSHdop).floatValue()), 1000);
                this.Encod.setValue(768, Float.valueOf(new Double(this.NV2_ElapsedTime).floatValue()), 31);
                this.Encod.setValue(334, (double)new Double(this.NV2_RemainAlignTime).floatValue() * 60.0, 31);
                this.Encod.setValue(773, this.NV2_AnsToCdiCmd, 1000);
                this.Encod.setValue(774, this.NV2_CdiCmd, 1000);
                this.Encod.setValue(775, this.NV2_CdiData, 1000);
                this.Encod.setValue(129, Float.valueOf(new Double(this.NV2_LatitudeSD).floatValue()), 11);
                this.Encod.setValue(130, Float.valueOf(new Double(this.NV2_LongitudeSD).floatValue()), 11);
                this.Encod.setValue(131, Float.valueOf(new Double(this.NV2_AltitudeSD).floatValue()), 11);
                double UtcTime_h = new Double(this.NV3_UtcHours).floatValue() * 3600.0f;
                double UtcTime_m = new Double(this.NV3_UtcMinutes).floatValue() * 60.0f;
                double UtcTime_s = new Double(this.NV3_UtcSeconds).floatValue();
                this.UtcTime = UtcTime_h + UtcTime_m + UtcTime_s;
                this.Encod.setValue(100, this.UtcTime, 31);
                this.Encod.setValue(162, Float.valueOf(new Double(this.NV3_GpsLatitude).floatValue()), 1);
                this.Encod.setValue(163, Float.valueOf(new Double(this.NV3_GpsLongitude).floatValue()), 1);
                this.Encod.setValue(164, Float.valueOf(new Double(this.NV3_GpsAltitude).floatValue()), 11);
                this.Encod.setValue(771, this.NV3_GpsValidity, 1000);
                this.Encod.setValue(772, this.NV3_GpsMode, 1000);
                LoggerDecoderFrame.FrameReady = true;
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[0].contentEquals("$PCREP")) {
            if (params.length != 10) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Format error");
                return -1;
            }
            if (!params[1].contentEquals("04")) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Version error");
                return -1;
            }
            if (!RegExp.is_hexa4(params[2])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Optimal Nav.Status error");
                return -1;
            }
            if (!params[3].isEmpty() && !RegExp.is_d2(params[3])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Update Cmd Answer error");
                return -1;
            }
            if (!params[4].isEmpty() && !RegExp.is_d2(params[4])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Mode Cmd Answer error");
                return -1;
            }
            if (!RegExp.is_s_f2pt7(params[5])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Latitude error");
                return -1;
            }
            if (!RegExp.is_s_f3pt7(params[6])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Longitude error");
                return -1;
            }
            if (!RegExp.is_s_f4pt2(params[7])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Altitude error");
                return -1;
            }
            if (!RegExp.is_s_f2pt2(params[8])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Horizontal speed error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.REP_StatusOptimalNav = params[2];
                this.REP_UpdateCmdAns = params[3];
                this.REP_ModeCmdAns = params[4];
                this.Latitude = params[5];
                this.Longitude = params[6];
                this.Altitude = params[7];
                this.HorizontalSpeed = params[8];
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[0].contentEquals("$PCNV1")) {
            if (params.length != 18) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Format error");
                return -1;
            }
            if (!params[1].contentEquals("04")) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Version error");
                return -1;
            }
            if (!RegExp.is_hexa4(params[2])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Sensor list error");
                return -1;
            }
            if (!params[3].contentEquals("S")) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Time type error");
                return -1;
            }
            if (!RegExp.is_d9(params[4])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " System time error");
                return -1;
            }
            if (!RegExp.is_hexa4(params[5])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Active mode error");
                return -1;
            }
            if (!RegExp.is_hexa4(params[6])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Failure report error");
                return -1;
            }
            if (!RegExp.is_s_f2pt7(params[7])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Latitude error");
                return -1;
            }
            if (!RegExp.is_s_f3pt7(params[8])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Longitude error");
                return -1;
            }
            if (!RegExp.is_s_f4pt2(params[9])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Altitude error");
                return -1;
            }
            if (!RegExp.is_ns_f3pt4(params[10])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Heading error");
                return -1;
            }
            if (!RegExp.is_s_f2pt2(params[11])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Horizontal speed error");
                return -1;
            }
            if (!RegExp.is_ns_f7pt2(params[12])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Distance travelled error");
                return -1;
            }
            if (!RegExp.is_ns_f2pt3(params[13])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Heading SD error");
                return -1;
            }
            if (!RegExp.is_ns_f2pt2(params[14])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Position SD error");
                return -1;
            }
            if (!RegExp.is_d2(params[15])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " GPS Sat.Nb error");
                return -1;
            }
            if (!RegExp.is_ns_f2pt1(params[16])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " GPS Hdop error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.NV1_StatusSensorList = params[2];
                this.NV1_SystemTime = params[4];
                this.NV1_StatusActiveMode = params[5];
                this.NV1_StatusFailureReport = params[6];
                this.Latitude = params[7];
                this.Longitude = params[8];
                this.Altitude = params[9];
                this.Heading = params[10];
                this.HorizontalSpeed = params[11];
                this.NV1_DistanceTravelled = params[12];
                this.NV1_HeadingSD = params[13];
                this.NV1_PositionSD = params[14];
                this.NV1_GPSSatNb = params[15];
                this.NV1_GPSHdop = params[16];
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[0].contentEquals("$PCNV2")) {
            if (params.length != 13) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Format error");
                return -1;
            }
            if (!params[1].contentEquals("02")) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Version error");
                return -1;
            }
            if (!RegExp.is_d6(params[2])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Elapsed time error");
                return -1;
            }
            if (!RegExp.is_d2(params[3])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Remaining Align.time error");
                return -1;
            }
            if (!params[4].isEmpty() && !RegExp.is_d2(params[4])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Answer to CDI Cmd error");
                return -1;
            }
            if (!params[5].isEmpty() && !RegExp.is_d4(params[5])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " CDI Cmd error");
                return -1;
            }
            if (!params[6].isEmpty() && !RegExp.is_d16(params[6])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " CDI Data error");
                return -1;
            }
            if (!RegExp.is_s_f3pt4(params[7])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Roll error");
                return -1;
            }
            if (!RegExp.is_s_f2pt4(params[8])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Pitch error");
                return -1;
            }
            if (!RegExp.is_ns_f2pt2(params[9])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Latitude cov. error");
                return -1;
            }
            if (!RegExp.is_ns_f2pt2(params[10])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Longitude cov. error");
                return -1;
            }
            if (!RegExp.is_ns_f2pt2(params[11])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Altitude cov. error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.NV2_ElapsedTime = params[2];
                this.NV2_RemainAlignTime = params[3];
                if (!params[4].isEmpty()) {
                    this.NV2_AnsToCdiCmd = params[4];
                }
                if (!params[5].isEmpty()) {
                    this.NV2_CdiCmd = params[5];
                }
                if (!params[6].isEmpty()) {
                    this.NV2_CdiData = params[6];
                }
                this.Roll = params[7];
                this.Pitch = params[8];
                this.NV2_LatitudeSD = params[9];
                this.NV2_LongitudeSD = params[10];
                this.NV2_AltitudeSD = params[11];
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else if (params[0].contentEquals("$PCNV3")) {
            if (params.length != 15) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Format error");
                return -1;
            }
            if (!params[1].contentEquals("01")) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Version error");
                return -1;
            }
            if (!RegExp.is_d4(params[2])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Reserved 1 error");
                return -1;
            }
            if (!RegExp.is_d2(params[3])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Reserved 2 error");
                return -1;
            }
            if (!RegExp.is_d2(params[4])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Reserved 3 error");
                return -1;
            }
            if (!RegExp.is_d2(params[5])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " UTC Hours error");
                return -1;
            }
            if (!RegExp.is_d2(params[6])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " UTC Minutes error");
                return -1;
            }
            if (!RegExp.is_d2(params[7])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " UTC Seconds error");
                return -1;
            }
            if (!params[8].contentEquals("0")) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Reserved 4 error");
                return -1;
            }
            if (!params[9].isEmpty() && !RegExp.is_s_f2pt7(params[9])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Gps Latitude error");
                return -1;
            }
            if (!params[10].isEmpty() && !RegExp.is_s_f3pt7(params[10])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Gps Longitude error");
                return -1;
            }
            if (!params[11].isEmpty() && !RegExp.is_s_f4pt2(params[11])) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Gps Altitude error");
                return -1;
            }
            if (!(params[12].isEmpty() || params[12].contentEquals("0") || params[12].contentEquals("1") || params[12].contentEquals("3"))) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Gps Validity error");
                return -1;
            }
            if (!(params[13].isEmpty() || params[13].contentEquals("01") || params[13].contentEquals("03"))) {
                this.InterpretedFrame_AddToList(sFrame_no_crlf + " Gps Mode error");
                return -1;
            }
            if (this.GetCurvePlotImplementation()) {
                this.NV3_UtcHours = params[5];
                this.NV3_UtcMinutes = params[6];
                this.NV3_UtcSeconds = params[7];
                if (!params[9].isEmpty()) {
                    this.NV3_GpsLatitude = params[9];
                }
                if (!params[10].isEmpty()) {
                    this.NV3_GpsLongitude = params[10];
                }
                if (!params[11].isEmpty()) {
                    this.NV3_GpsAltitude = params[11];
                }
                if (!params[12].isEmpty()) {
                    this.NV3_GpsValidity = params[12];
                }
                if (!params[13].isEmpty()) {
                    this.NV3_GpsMode = params[13];
                }
            }
            this.InterpretedFrame_AddToList(sFrame_no_crlf);
        } else {
            this.InterpretedFrame_AddToList(sFrame_no_crlf + " Header error");
            return -1;
        }
        return 0;
    }
}

