/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class SIGRS4_Decoder
extends Decoder {
    private Encoder Encod;

    public SIGRS4_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 85;
        Start_Blk[1] = 85;
        int Length_Blk = 30;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Counter" + sep + "Status" + sep + "Heading(rad)" + sep + "Pitch(rad)" + sep + "Roll(rad)" + sep + "Roll rate(rad/s)" + sep + "Pitch rate(rad/s)" + sep + "Heading Rate(rad/s)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        int Chk = 0;
        if (Detected_Frame[0] != 85 || Detected_Frame[1] != 85) {
            this.InterpretedFrame_AddToList("Start Word error");
            return -1;
        }
        if (Detected_Frame[28] != -86 || Detected_Frame[29] != -86) {
            this.InterpretedFrame_AddToList("End Word error");
            return -1;
        }
        if (Detected_Frame[24] != 0 || Detected_Frame[25] != 0 || Detected_Frame[26] != 0) {
            this.InterpretedFrame_AddToList("Checksum error");
            return -1;
        }
        for (int i = 0; i < 24; ++i) {
            Chk ^= Detected_Frame[i];
        }
        if (Chk != Detected_Frame[27]) {
            this.InterpretedFrame_AddToList("Checksum error");
            return -1;
        }
        int Counter = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 2, 1);
        int Status = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 4, 1);
        double Heading = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 6, 1) * Math.PI / Math.pow(2.0, 31.0);
        double Pitch = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 10, 1) * Math.PI / Math.pow(2.0, 31.0);
        double Roll = (double)this.Convert_4Bytes_to_SignedInt(Detected_Frame, 14, 1) * Math.PI / Math.pow(2.0, 31.0);
        double RollRate = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 18, 1) * 2.0 / Math.pow(2.0, 15.0);
        double PitchRate = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 20, 1) * 2.0 / Math.pow(2.0, 15.0);
        double HeadingRate = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 22, 1) * 2.0 / Math.pow(2.0, 15.0);
        this.InterpretedFrame = this.InterpretDouble(Counter);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsBin(Status);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(RollRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(PitchRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(HeadingRate);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(701, Counter, 1000);
            this.Encod.setValue(1000, Status, 1000);
            if (Heading < 0.0) {
                Heading += Math.PI * 2;
            }
            this.Encod.setValue(103, Float.valueOf((float)Heading), 2);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 2);
            this.Encod.setValue(104, Float.valueOf((float)Roll), 2);
            this.Encod.setValue(111, Float.valueOf((float)RollRate), 52);
            this.Encod.setValue(112, Float.valueOf(-((float)PitchRate)), 52);
            this.Encod.setValue(110, Float.valueOf((float)HeadingRate), 52);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

