/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class SOC_AUTOSUB_Decoder
extends Decoder {
    private final Encoder Encod;
    private String ProtocolName;

    public SOC_AUTOSUB_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 61;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Status" + sep + "Heading(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "XV3_rate(\u00b0/s)" + sep + "XV1_rate(\u00b0/s)" + sep + "XV2_rate(\u00b0/s)" + sep + "Depth(m)" + sep + "Douwn_speed(m/s)" + sep + "East_speed(m/s)" + sep + "South_speed(m/s)" + sep + "Lat(\u00b0)" + sep + "Long(\u00b0)" + sep + "LogStd(\u00b0)or Time(s)" + sep + "Cnt";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        float Log_std = 0.0f;
        double Time_s = 0.0;
        this.ProtocolName = this.Info.GetProtocolName();
        byte[] Chk = new byte[1];
        for (int i = 0; i < 60; ++i) {
            Chk[0] = (byte)(Chk[0] + this.Bytes_Frame[i]);
        }
        if (Chk[0] != this.Bytes_Frame[60]) {
            this.InterpretedFrame = this.InterpretString("Checksum error");
            return -1;
        }
        if (!this.ProtocolName.matches("DORADO_2")) {
            for (int n = 54; n < 58; ++n) {
                if (this.Bytes_Frame[n] == 0) continue;
                return -1;
            }
        }
        byte Status = this.Bytes_Frame[1];
        float Heading = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 2, 1) * 180.0 / Math.PI);
        float Roll = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 6, 1) * 180.0 / Math.PI);
        float Pitch = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 10, 1) * 180.0 / Math.PI);
        float XV3RotRate = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 14, 1) * 180.0 / Math.PI);
        float XV1RotRate = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 18, 1) * 180.0 / Math.PI);
        float XV2RotRate = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 22, 1) * 180.0 / Math.PI);
        float Depth = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 26, 1);
        float Down_speed = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 30, 1);
        float East_speed = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 34, 1);
        float South_speed = this.Convert_4Bytes_to_Float(this.Bytes_Frame, 38, 1);
        double Lat = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 42, 1) * 180.0 / 2.147483648E9;
        double Long2 = (double)this.Convert_4Bytes_to_SignedInt(this.Bytes_Frame, 46, 1) * 180.0 / 2.147483648E9;
        if (this.ProtocolName.matches("DORADO_2")) {
            if (Long2 < 0.0) {
                Long2 = (float)(Math.PI * 2 + Long2);
            }
            Time_s = this.Convert_8Bytes_to_Double(this.Bytes_Frame, 50, 1);
        } else {
            Log_std = (float)((double)this.Convert_4Bytes_to_Float(this.Bytes_Frame, 50, 1) * 180.0 / Math.PI);
        }
        int Cnt = this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 58, 1);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(1000, this.Bytes_Frame[1], 1000);
            if (this.ProtocolName.matches("DORADO_2")) {
                this.Encod.setValue(102, Time_s, 31);
            } else {
                this.Encod.setValue(258, Float.valueOf(Log_std), 1);
            }
            this.Encod.setValue(103, Float.valueOf(Heading), 1);
            this.Encod.setValue(104, Float.valueOf(Roll), 1);
            this.Encod.setValue(105, Float.valueOf(Pitch), 1);
            this.Encod.setValue(116, Float.valueOf(XV3RotRate), 51);
            this.Encod.setValue(114, Float.valueOf(XV1RotRate), 51);
            this.Encod.setValue(115, Float.valueOf(-XV2RotRate), 51);
            this.Encod.setValue(126, Float.valueOf(-Depth), 11);
            this.Encod.setValue(138, Float.valueOf(-Down_speed), 21);
            this.Encod.setValue(137, Float.valueOf(East_speed), 21);
            this.Encod.setValue(136, Float.valueOf(-South_speed), 21);
            this.Encod.setValue(124, Lat, 1);
            this.Encod.setValue(125, Long2, 1);
            this.Encod.setValue(701, this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 58, 1), 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretIntegerAsInt(Status);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heading, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV3RotRate, 314);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV1RotRate, 312);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(XV2RotRate, 313);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Depth, 246);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Down_speed, 138);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(East_speed, 137);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(South_speed, 136);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Lat, 124);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Long2, 125);
        this.InterpretedFrame = this.ProtocolName.matches("DORADO_2") ? this.InterpretedFrame + this.InterpretDouble(Time_s, 6) : this.InterpretedFrame + this.InterpretFloat(Log_std, 130);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsInt(Cnt);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

