/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class SPERRY_ATT_Decoder
extends Decoder {
    private Encoder Encod;

    public SPERRY_ATT_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = -86;
        Start_Blk[1] = 85;
        int Length_Blk = 18;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Time(s)" + sep + "Heading(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "HeadingRate(\u00b0/s)" + sep + "RollRate(\u00b0/s)" + sep + "PitchRate(\u00b0/s)" + sep + "Status(bits 11 to 15)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        byte[] Chk = new byte[1];
        if (Detected_Frame[0] != -86) {
            return 0;
        }
        if (Detected_Frame[1] != 85) {
            return 0;
        }
        for (int i = 0; i < 16; ++i) {
            Chk[0] = (byte)(Chk[0] + Detected_Frame[i]);
        }
        if (-Chk[0] != Detected_Frame[16]) {
            return 0;
        }
        if (~(-Chk[0]) != Detected_Frame[17]) {
            return 0;
        }
        int Status = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 2, 1);
        double Time = (double)(Status & 0x3FF) / 799.0;
        int Status_Alignment = Status & 0x800;
        int Status_SysWarning = Status & 0x1000;
        int Status_SysAlarm = Status & 0x2000;
        int Status_SysMalFunction = Status & 0x4000;
        int Status_SysFail = Status & 0x8000;
        Status &= 0xFC00;
        double Heading = (double)this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 4, 1) * 180.0 / 32768.0;
        double Roll = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 6, 1) * 90.0 / 32768.0;
        double Pitch = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 8, 1) * 90.0 / 32768.0;
        double HeadingRate = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 10, 1) * 45.0 / 32768.0;
        double RollRate = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 12, 1) * 45.0 / 32768.0;
        double PitchRate = (double)this.Convert_2Bytes_to_SignedInt(Detected_Frame, 14, 1) * 45.0 / 32768.0;
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(100, Float.valueOf((float)Time), 31);
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            this.Encod.setValue(104, Float.valueOf(-((float)Roll)), 1);
            this.Encod.setValue(105, Float.valueOf((float)Pitch), 1);
            this.Encod.setValue(110, Float.valueOf((float)HeadingRate), 51);
            this.Encod.setValue(111, Float.valueOf(-((float)RollRate)), 51);
            this.Encod.setValue(112, Float.valueOf((float)PitchRate), 51);
            this.Encod.setValue(1003, Status_Alignment, 1000);
            this.Encod.setValue(1019, Status_SysWarning, 1000);
            this.Encod.setValue(1020, Status_SysAlarm, 1000);
            this.Encod.setValue(1021, Status_SysMalFunction, 1000);
            this.Encod.setValue(1022, Status_SysFail, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame = this.InterpretDouble(Time);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heading);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Roll);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(HeadingRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(RollRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(PitchRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsBin(Status);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

