/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class STANDARD_2_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public STANDARD_2_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 58;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        int HeaveStatus = 0;
        int HeadingStatus = 0;
        ++this.current_line;
        Pattern p = Pattern.compile("(:)(\\d{5})(\\p{Space})(\\p{Punct}?|\\p{Space})(\\d{4})(h?|H)(\\p{Punct}?|\\p{Space})(\\d{4})(\\p{Space})(\\p{Punct}?|\\p{Space})(\\d{4})(f?|F?|A)");
        Matcher m = p.matcher(sFrame_no_crlf);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            String sHeading = m.group(2);
            String sHeaveSign = m.group(4);
            String sHeave = m.group(5);
            String sHeaveStatus = m.group(6);
            String sRollSign = m.group(7);
            String sRoll = m.group(8);
            String sPitchSign = m.group(10);
            String sPitch = m.group(11);
            String sHeadingStatus = m.group(12);
            double Heading = (double)Integer.parseInt(sHeading) * 0.01;
            double Heave = (double)Integer.parseInt(sHeave) * 0.01;
            if (sHeaveSign.matches("-")) {
                Heave = -Heave;
            }
            switch (sHeaveStatus) {
                case "h": {
                    HeaveStatus = 104;
                    break;
                }
                case "H": {
                    HeaveStatus = 72;
                }
            }
            double Roll = (double)Integer.parseInt(sRoll) * 0.01;
            if (sRollSign.matches("-")) {
                Roll = -Roll;
            }
            double Pitch = (double)Integer.parseInt(sPitch) * 0.01;
            if (sPitchSign.matches("-")) {
                Pitch = -Pitch;
            }
            switch (sHeadingStatus) {
                case "f": {
                    HeadingStatus = 102;
                    break;
                }
                case "F": {
                    HeadingStatus = 70;
                    break;
                }
                case "A": {
                    HeadingStatus = 65;
                }
            }
            this.Encod.setValue(103, Float.valueOf((float)Heading), 1);
            this.Encod.setValue(148, Float.valueOf((float)Heave), 11);
            this.Encod.setValue(1000, HeaveStatus, 1000);
            this.Encod.setValue(104, Float.valueOf((float)Roll), 1);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 1);
            this.Encod.setValue(1001, HeadingStatus, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

