/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class STOLT_OFFSHORE_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public STOLT_OFFSHORE_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
            return -1;
        }
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!params[0].contentEquals("$PSXN")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error");
            return -1;
        }
        if (!params[1].contentEquals("10") && !params[1].contentEquals("11")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Status error");
            return -1;
        }
        if (!params[2].contentEquals("014") && !params[2].contentEquals("14")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " User ID error");
            return -1;
        }
        if (params[2].contentEquals("014") && params.length != 11) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        if (params[2].contentEquals("14") && params.length != 10) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        Pattern p = Pattern.compile("^[-]?[0-9]+\\.[0-9]+[eE][-+]?[0-9]+$");
        Matcher m = p.matcher(params[3]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch format error");
            return -1;
        }
        m = p.matcher(params[4]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll format error");
            return -1;
        }
        m = p.matcher(params[5]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading format error");
            return -1;
        }
        m = p.matcher(params[6]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch rate format error");
            return -1;
        }
        m = p.matcher(params[7]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll rate format error");
            return -1;
        }
        m = p.matcher(params[8]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading format error");
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            int status = Integer.parseInt(params[1], 16);
            this.Encod.setValue(105, Float.valueOf(-new Double(params[3]).floatValue()), 2);
            this.Encod.setValue(104, Float.valueOf(new Double(params[4]).floatValue()), 2);
            this.Encod.setValue(103, Float.valueOf(new Double(params[5]).floatValue()), 2);
            this.Encod.setValue(112, Float.valueOf(-new Double(params[6]).floatValue()), 52);
            this.Encod.setValue(111, Float.valueOf(new Double(params[7]).floatValue()), 52);
            this.Encod.setValue(110, Float.valueOf(-new Double(params[8]).floatValue()), 52);
            this.Encod.setValue(1025, status, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

