/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class TAH_BIN_Decoder
extends Decoder {
    private Encoder Encod;

    public TAH_BIN_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 42;
        Start_Blk[1] = 59;
        int Length_Blk = 59;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Status" + sep + "Time(s)" + sep + "Heading(\u00b0)" + sep + "Roll(\u00b0)" + sep + "Pitch(\u00b0)" + sep + "Heave(mm)" + sep + "Surge(mm)" + sep + "Sway(mm)" + sep + "HeadingRate(\u00b0/s)" + sep + "RollRate(\u00b0/s)" + sep + "PitchRate(\u00b0/s)" + sep + "HeaveSpeed(mm/s)" + sep + "SurgeSpeed(mm/s)" + sep + "SwaySpeed(mm/s)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        byte[] Chk = new byte[1];
        if (Detected_Frame[0] != 42) {
            this.InterpretedFrame = this.InterpretString("ID error");
            return 0;
        }
        if (Detected_Frame[1] != 59) {
            this.InterpretedFrame = this.InterpretString("Length error");
            return 0;
        }
        for (int i = 0; i < 58; ++i) {
            Chk[0] = (byte)(Chk[0] ^ Detected_Frame[i]);
        }
        if (Chk[0] != Detected_Frame[58]) {
            this.InterpretedFrame = this.InterpretString("Checksum error");
            return 0;
        }
        long Status = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 2, 1);
        float Time = (float)((double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 6, 1) * 86400.0 / 4.294967296E9);
        float Heading = this.Convert_4Bytes_to_Float(Detected_Frame, 10, 1);
        float Roll = this.Convert_4Bytes_to_Float(Detected_Frame, 14, 1);
        float Pitch = this.Convert_4Bytes_to_Float(Detected_Frame, 18, 1);
        float Heave = this.Convert_4Bytes_to_Float(Detected_Frame, 22, 1);
        float Surge = this.Convert_4Bytes_to_Float(Detected_Frame, 26, 1);
        float Sway = this.Convert_4Bytes_to_Float(Detected_Frame, 30, 1);
        float HeadingRate = this.Convert_4Bytes_to_Float(Detected_Frame, 34, 1);
        float RollRate = this.Convert_4Bytes_to_Float(Detected_Frame, 38, 1);
        float PitchRate = this.Convert_4Bytes_to_Float(Detected_Frame, 42, 1);
        float HeaveSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, 46, 1);
        float SurgeSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, 50, 1);
        float SwaySpeed = this.Convert_4Bytes_to_Float(Detected_Frame, 54, 1);
        this.InterpretedFrame = this.InterpretLongAsBin(Status);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Time, 3);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heading, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heave, 148);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Surge, 150);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Sway, 151);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeadingRate, 110);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RollRate, 111);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PitchRate, 112);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeaveSpeed, 152);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SurgeSpeed, 153);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SwaySpeed, 154);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

