/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class TAH_BIN_SMT_Decoder
extends Decoder {
    private Encoder Encod;

    public TAH_BIN_SMT_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 42;
        Start_Blk[1] = 59;
        int Length_Blk = 59;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Status" + sep + "Time(s)" + sep + "Heading(deg)" + sep + "Roll(deg)" + sep + "Pitch(deg)" + sep + "Heave(mm)" + sep + "Surge(mm)" + sep + "Sway(mm)" + sep + "HeadingRate(deg/s)" + sep + "RollRate(deg/s)" + sep + "PitchRate(deg/s)" + sep + "HeaveSpeed(mm/s)" + sep + "SurgeSpeed(mm/s)" + sep + "SwaySpeed(mm/s)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Lenght) {
        byte[] Chk = new byte[1];
        for (int i = 0; i < 58; ++i) {
            Chk[0] = (byte)(Chk[0] ^ Detected_Frame[i]);
        }
        if (Chk[0] != Detected_Frame[58]) {
            this.InterpretedFrame = this.InterpretString("Checksum error");
            return -1;
        }
        long Status = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 2, 1);
        float Time = (float)((double)this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 6, 1) * 86400.0 / 4.294967296E9);
        float Heading = this.Convert_4Bytes_to_Float(Detected_Frame, 10, 1);
        float Roll = this.Convert_4Bytes_to_Float(Detected_Frame, 14, 1);
        float Pitch = this.Convert_4Bytes_to_Float(Detected_Frame, 18, 1);
        float Heave = this.Convert_4Bytes_to_Float(Detected_Frame, 22, 1);
        float Surge = this.Convert_4Bytes_to_Float(Detected_Frame, 26, 1);
        float Sway = this.Convert_4Bytes_to_Float(Detected_Frame, 30, 1);
        float HeadingRate = this.Convert_4Bytes_to_Float(Detected_Frame, 34, 1);
        float RollRate = this.Convert_4Bytes_to_Float(Detected_Frame, 38, 1);
        float PitchRate = this.Convert_4Bytes_to_Float(Detected_Frame, 42, 1);
        float HeaveSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, 46, 1);
        float SurgeSpeed = this.Convert_4Bytes_to_Float(Detected_Frame, 50, 1);
        float SwaySpeed = this.Convert_4Bytes_to_Float(Detected_Frame, 54, 1);
        this.InterpretedFrame = this.InterpretLongAsBin(Status);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Time);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heading);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Roll);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Pitch);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Heave);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Surge);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Sway);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeadingRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(RollRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(PitchRate);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(HeaveSpeed);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SurgeSpeed);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(SwaySpeed);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(708, Detected_Frame[0], 1000);
            this.Encod.setValue(709, Detected_Frame[1], 1000);
            this.Encod.setValue(610, Integer.toHexString((int)Status), 1000);
            this.Encod.setValue(100, Float.valueOf(Time), 31);
            this.Encod.setValue(103, Float.valueOf(Heading), 1);
            this.Encod.setValue(104, Float.valueOf(Roll), 1);
            this.Encod.setValue(105, Float.valueOf(Pitch), 1);
            this.Encod.setValue(148, Float.valueOf(Heave / 1000.0f), 11);
            this.Encod.setValue(150, Float.valueOf(Surge / 1000.0f), 11);
            this.Encod.setValue(151, Float.valueOf(Sway / 1000.0f), 11);
            this.Encod.setValue(110, Float.valueOf(HeadingRate), 51);
            this.Encod.setValue(111, Float.valueOf(RollRate), 51);
            this.Encod.setValue(112, Float.valueOf(PitchRate), 51);
            this.Encod.setValue(152, Float.valueOf(HeaveSpeed / 1000.0f), 21);
            this.Encod.setValue(153, Float.valueOf(SurgeSpeed / 1000.0f), 21);
            this.Encod.setValue(154, Float.valueOf(SwaySpeed / 1000.0f), 21);
            this.Encod.setValue(724, Detected_Frame[58], 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

