/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TECHSAS_Decoder
extends Decoder {
    private Encoder Encod;
    private int current_line;

    public TECHSAS_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 36;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        ++this.current_line;
        String[] params = sFrame_no_crlf.replace("*", ",").split(",");
        if (!this.NmeaChkMatches(sFrame_no_crlf)) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " NMEA checksum error");
            return -1;
        }
        if (!params[0].contentEquals("$PASHR")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Header error");
            return -1;
        }
        if (params.length != 13) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        if (!params[3].contentEquals("T")) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        Pattern p = Pattern.compile("(\\d{2})(\\d{2})(\\d{2})+\\.(\\d{3})");
        Matcher m = p.matcher(params[1]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " UTC Time format error");
            return -1;
        }
        p = Pattern.compile("([0-9]+\\.(\\d{2}))");
        m = p.matcher(params[2]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading format error");
            return -1;
        }
        p = Pattern.compile("(^[-+][0-9]+\\.(\\d{2}))");
        m = p.matcher(params[4]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll format error");
            return -1;
        }
        m = p.matcher(params[5]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch format error");
            return -1;
        }
        m = p.matcher(params[6]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heave format error");
            return -1;
        }
        p = Pattern.compile("(^[-]?[0-9]+\\.(\\d{3}))");
        m = p.matcher(params[7]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Roll SD format error");
            return -1;
        }
        m = p.matcher(params[8]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Pitch SD format error");
            return -1;
        }
        m = p.matcher(params[9]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Heading SD format error");
            return -1;
        }
        p = Pattern.compile("(0?|1?)");
        m = p.matcher(params[10]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " GPS aiding status format error");
            return -1;
        }
        m = p.matcher(params[11]);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " GPS aiding status format error");
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(100, Float.valueOf(new Double(params[1]).floatValue()), 34);
            this.Encod.setValue(103, Float.valueOf(new Double(params[2]).floatValue()), 1);
            this.Encod.setValue(104, Float.valueOf(new Double(params[4]).floatValue()), 1);
            this.Encod.setValue(105, Float.valueOf(-new Double(params[5]).floatValue()), 1);
            this.Encod.setValue(148, Float.valueOf(-new Double(params[6]).floatValue()), 11);
            this.Encod.setValue(108, Float.valueOf(new Double(params[7]).floatValue()), 1);
            this.Encod.setValue(109, Float.valueOf(new Double(params[8]).floatValue()), 1);
            this.Encod.setValue(107, Float.valueOf(new Double(params[9]).floatValue()), 1);
            this.Encod.setValue(1000, params[10], 1000);
            this.Encod.setValue(1001, params[11], 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

