/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class TMS_CCV_IMBAT_Decoder
extends Decoder {
    private final Encoder Encod;
    final double GMS_2 = 9.8095378;

    public TMS_CCV_IMBAT_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 0;
        Start_Blk[1] = -112;
        int Length_Blk = 24;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Roll" + sep + "Pitch" + sep + "Heading" + sep + "XV1RotRate" + sep + "XV2RotRate" + sep + "XV3RotRate" + sep + "Heave" + sep + "XV1acc" + sep + "XV2acc" + sep + "XV3acc" + sep + "status";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        double Roll = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 2, 0) * Math.PI / 32768.0;
        double Pitch = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 4, 0) * Math.PI / 32768.0;
        double Head = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 8, 0) * Math.PI / 32768.0;
        double rollRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 16, 0) * 20.0 / 32768.0;
        double pitchRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 18, 0) * 20.0 / 32768.0;
        double headRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 20, 0) * 20.0 / 32768.0;
        double Heave = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 6, 0) * 327.0 / 32768.0;
        double XV1acc = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 10, 0) * 0.5 / 32768.0;
        double XV2acc = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 12, 0) * 0.5 / 32768.0;
        double XV3acc = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 14, 0) * 0.5 / 32768.0;
        String Status = Integer.toHexString(this.Convert_1Byte_to_SignedInt(this.Bytes_Frame, 22, 0));
        this.InterpretedFrame = this.InterpretString("$TMS");
        this.InterpretedFrame = this.InterpretDouble(Roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Head, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(rollRate, 114);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(pitchRate, 115);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(headRate, 116);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Heave, 148);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV1acc, 121);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV2acc, 122);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV3acc, 123);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretString(Status);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(104, Float.valueOf((float)Roll), 2);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 2);
            this.Encod.setValue(148, Float.valueOf(-((float)Heave)), 11);
            this.Encod.setValue(103, Float.valueOf((float)Head), 2);
            this.Encod.setValue(121, XV1acc * 9.8095378, 43);
            this.Encod.setValue(122, XV2acc * 9.8095378, 43);
            this.Encod.setValue(123, XV3acc * 9.8095378, 43);
            this.Encod.setValue(114, Float.valueOf((float)rollRate), 1);
            this.Encod.setValue(115, Float.valueOf(-((float)pitchRate)), 1);
            this.Encod.setValue(116, Float.valueOf(-((float)headRate)), 1);
            this.Encod.setValue(1000, Status, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

