/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class TRS_AHRS_Decoder
extends Decoder {
    public static final int REP_BLOCK_LENGTH = 72;
    public static final int OPE_BLOCK_LENGTH = 34;
    private Encoder Encod;

    public TRS_AHRS_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 4;
        byte[] Start_Blk_n1 = new byte[Start_Blk_Length];
        byte[] Start_Blk_n2 = new byte[Start_Blk_Length];
        Start_Blk_n1[0] = 36;
        Start_Blk_n1[1] = 82;
        Start_Blk_n1[2] = 69;
        Start_Blk_n1[3] = 80;
        int Length_Blk_n1 = 72;
        Start_Blk_n2[0] = 36;
        Start_Blk_n2[1] = 79;
        Start_Blk_n2[2] = 80;
        Start_Blk_n2[3] = 69;
        int Length_Blk_n2 = 34;
        this.DecodeInit(0, Length_Blk_n1, Start_Blk_n1, Start_Blk_Length);
        this.DecodeInit(0, Length_Blk_n2, Start_Blk_n2, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "$XXX" + sep + "Time_CPtr" + sep + "Delay" + sep + "Command" + sep + "State" + sep + "Synthesis" + sep + "Datas\n";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        Integer State2;
        Integer Command;
        if (Length == 72) {
            Command = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 8, 1);
            State2 = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 6, 1);
            float Heading_Misa = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 10, 1) * 1.0E-4 * 180.0 / Math.PI);
            float Roll_Misa = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 12, 1) * 1.0E-4 * 180.0 / Math.PI);
            float Pitch_Misa = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 14, 1) * 1.0E-4 * 180.0 / Math.PI);
            this.InterpretedFrame = this.InterpretString("$REP");
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretString("N/A");
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretString("N/A");
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(Command);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(State2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretString("N/A");
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(103, Float.valueOf(Heading_Misa), 2);
                this.Encod.setValue(104, Float.valueOf(Roll_Misa), 2);
                this.Encod.setValue(105, Float.valueOf(Pitch_Misa), 2);
                LoggerDecoderFrame.FrameReady = true;
            }
            this.InterpretedFrame_AddToList(this.InterpretedFrame);
        }
        if (Length == 34) {
            Command = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 6, 1);
            State2 = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 8, 1);
            Integer Synthesis = this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 10, 1);
            float Heading = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 12, 1) * 2.0E-4 * 180.0 / Math.PI);
            float Roll = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 16, 1) * 2.0E-4 * 180.0 / Math.PI);
            float Pitch = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 20, 1) * 2.0E-4 * 180.0 / Math.PI);
            float Heading_Std = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 14, 1) * 2.0E-4 * 180.0 / Math.PI);
            float Roll_Std = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 18, 1) * 2.0E-4 * 180.0 / Math.PI);
            float Pitch_Std = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 22, 1) * 2.0E-4 * 180.0 / Math.PI);
            float Time_Cptr = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 26, 1) * 0.1);
            float Delay = (float)((double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 28, 1) * 0.2);
            this.InterpretedFrame = this.InterpretString("$OPE");
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Time_Cptr);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(Delay);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(Command);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(State2);
            this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex(Synthesis);
            if (this.GetCurvePlotImplementation()) {
                this.Encod.setValue(103, Float.valueOf(Heading), 2);
                this.Encod.setValue(107, Float.valueOf(Heading_Std), 2);
                this.Encod.setValue(104, Float.valueOf(Roll), 2);
                this.Encod.setValue(108, Float.valueOf(Roll_Std), 2);
                this.Encod.setValue(105, Float.valueOf(Pitch), 2);
                this.Encod.setValue(109, Float.valueOf(Pitch_Std), 2);
                LoggerDecoderFrame.FrameReady = true;
            }
            this.InterpretedFrame_AddToList(this.InterpretedFrame);
            return 0;
        }
        return 0;
    }
}

