/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TSS1_DMS_Decoder
extends Decoder {
    private Encoder Encod;
    final double GMS_2 = 9.8095378;
    private int current_line;

    public TSS1_DMS_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        this.current_line = 0;
        int Start_Blk_Length = 1;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 58;
        int Length_Blk = 0;
        this.DecodeInit(1, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        String sFrame_no_crlf = new String(Decoded_Frame, 0, Lenght - 2);
        int Status = 0;
        ++this.current_line;
        Pattern p = Pattern.compile("(:)([0-9A-Fa-f]{2})([0-9A-Fa-f]{4})(\\p{Space})(\\p{Punct}?|\\p{Space})(\\d{4})(h?|H)(\\p{Punct}?|\\p{Space})(\\d{4})(\\p{Space})(\\p{Punct}?|\\p{Space})(\\d{4})");
        Matcher m = p.matcher(sFrame_no_crlf);
        if (!m.matches()) {
            this.InterpretedFrame_AddToList(Integer.toString(this.current_line) + " Format error");
            return -1;
        }
        if (this.GetCurvePlotImplementation()) {
            double VertAcc;
            String sHoriAcc = m.group(2);
            String sVertAcc = m.group(3);
            String sHeaveSign = m.group(5);
            String sHeave = m.group(6);
            String sStatus = m.group(7);
            String sRollSign = m.group(8);
            String sRoll = m.group(9);
            String sPitchSign = m.group(11);
            String sPitch = m.group(12);
            double HoriAcc = Integer.parseInt(sHoriAcc, 16);
            if (HoriAcc > 256.0) {
                HoriAcc -= 512.0;
            }
            if ((VertAcc = (double)Integer.valueOf(sVertAcc, 16).intValue()) > 32767.0) {
                VertAcc -= 65536.0;
            }
            HoriAcc = HoriAcc * 0.01 * 3.83203125;
            VertAcc = VertAcc * 0.01 * 0.0625;
            double Heave = (double)Integer.parseInt(sHeave) * 0.01;
            if (sHeaveSign.matches("-")) {
                Heave = -Heave;
            }
            switch (sStatus) {
                case "h": {
                    Status = 104;
                    break;
                }
                case "H": {
                    Status = 72;
                    break;
                }
            }
            double Roll = (double)Integer.parseInt(sRoll) * 0.01;
            if (sRollSign.matches("-")) {
                Roll = -Roll;
            }
            double Pitch = (double)Integer.parseInt(sPitch) * 0.01;
            if (sPitchSign.matches("-")) {
                Pitch = -Pitch;
            }
            this.Encod.setValue(123, Float.valueOf((float)VertAcc), 43);
            this.Encod.setValue(148, Float.valueOf((float)Heave), 11);
            this.Encod.setValue(1003, Status, 1000);
            this.Encod.setValue(104, Float.valueOf((float)Roll), 1);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 1);
            this.Encod.setValue(725, Float.valueOf((float)HoriAcc), 43);
            LoggerDecoderFrame.FrameReady = true;
        }
        this.InterpretedFrame_AddToList(sFrame_no_crlf);
        return 0;
    }
}

