/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LoggerDecoderFrame;

public class TUS_Decoder
extends Decoder {
    private final Encoder Encod;
    final double GMS_2 = 9.8095378;

    public TUS_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(true);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = 0;
        Start_Blk[1] = -112;
        int Length_Blk = 29;
        this.DecodeInit(0, Length_Blk, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = this.Info.GetSeparator();
        return "Roll" + sep + "Pitch" + sep + "Heading" + sep + "RollRate" + sep + "PitchRate" + sep + ",HeadingRate" + sep + "HeaveSpeed" + sep + "SurgeSpeed" + sep + "SwaySpeed" + sep + "XV1acc" + sep + "XV2acc,XV3acc" + sep + "status";
    }

    @Override
    public int InterpretFrame(byte[] Decoded_Frame, int Lenght) {
        double Roll = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 2, 0) * Math.PI / 32768.0;
        double Pitch = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 4, 0) * Math.PI / 32768.0;
        double HeaveSpeed = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 6, 0) * 327.0 / 32768.0;
        double SurgeSpeed = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 8, 0) * 327.0 / 32768.0;
        double SwaySpeed = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 10, 0) * 327.0 / 32768.0;
        double Head = (double)this.Convert_2Bytes_to_UnsignedInt(this.Bytes_Frame, 12, 0) * Math.PI / 32768.0;
        double XV1acc = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 14, 0) * 0.5 / 32768.0;
        double XV2acc = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 16, 0) * 0.5 / 32768.0;
        double XV3acc = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 18, 0) * 0.5 / 32768.0;
        double XV1rotRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 20, 0) * 20.0 / 32768.0;
        double XV2rotRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 22, 0) * 20.0 / 32768.0;
        double XV3rotRate = (double)this.Convert_2Bytes_to_SignedInt(this.Bytes_Frame, 24, 0) * 20.0 / 32768.0;
        String Status = Integer.toHexString(this.Convert_1Byte_to_SignedInt(this.Bytes_Frame, 26, 0));
        this.InterpretedFrame = this.InterpretDouble(Roll, 104);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Pitch, 105);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Head, 103);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV1rotRate, 110);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV2rotRate, 111);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV3rotRate, 112);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(HeaveSpeed, 152);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(SurgeSpeed, 153);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(SwaySpeed, 154);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV1acc, 121);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV2acc, 122);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(XV3acc, 123);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretString(Status);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        if (this.GetCurvePlotImplementation()) {
            this.Encod.setValue(104, Float.valueOf((float)Roll), 2);
            this.Encod.setValue(105, Float.valueOf(-((float)Pitch)), 2);
            this.Encod.setValue(152, Float.valueOf(-((float)HeaveSpeed)), 21);
            this.Encod.setValue(153, Float.valueOf((float)SurgeSpeed), 21);
            this.Encod.setValue(154, Float.valueOf((float)SwaySpeed), 21);
            this.Encod.setValue(103, Float.valueOf((float)Head), 2);
            this.Encod.setValue(121, XV1acc * 9.8095378, 43);
            this.Encod.setValue(122, -(XV2acc * 9.8095378), 43);
            this.Encod.setValue(123, -(XV3acc * 9.8095378), 43);
            this.Encod.setValue(110, Float.valueOf((float)XV1rotRate), 51);
            this.Encod.setValue(111, Float.valueOf(-((float)XV2rotRate)), 51);
            this.Encod.setValue(112, Float.valueOf(-((float)XV3rotRate)), 51);
            this.Encod.setValue(1000, Status, 1000);
            LoggerDecoderFrame.FrameReady = true;
        }
        return 0;
    }
}

