/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;
import LoggerDecoder.LogInfo;
import Protocols.DataBlkAvg_Item;

public class XC_IMU_AVG_POSTPRO_Decoder
extends Decoder {
    int NbMax_DataBlk;
    int Nb_DataBlk;
    int Nb_DataBlk_Decoded;
    int DataBlock_version;
    int KeyBlock_version;
    boolean DoItOnce;
    float[] LastTemp = new float[8];
    public static final int NBMAX_DATABLK_AT200HZ = 12000;
    public static final int HEADER_BYTE = 36;
    public static final int DATABLK_00_LENGTH = 42;
    public static final int DATABLK_01_LENGTH = 69;
    public static final int DATABLK_02_LENGTH = 42;
    public static final int KEYBLK_10_LENGTH = 29;
    DataBlkAvg_Item[] datablk_item;

    public XC_IMU_AVG_POSTPRO_Decoder(Encoder Encod, LogInfo Info) {
        super(Info);
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 2;
        byte[] Start_DataBlk_00 = new byte[Start_Blk_Length];
        byte[] Start_DataBlk_01 = new byte[Start_Blk_Length];
        byte[] Start_DataBlk_02 = new byte[Start_Blk_Length];
        byte[] Start_KeyBlk_10 = new byte[Start_Blk_Length];
        Start_DataBlk_00[0] = 36;
        Start_DataBlk_00[1] = 32;
        Start_DataBlk_01[0] = 36;
        Start_DataBlk_01[1] = 33;
        Start_DataBlk_02[0] = 36;
        Start_DataBlk_02[1] = 34;
        Start_KeyBlk_10[0] = 36;
        Start_KeyBlk_10[1] = 16;
        this.DecodeInit(0, 29, Start_KeyBlk_10, Start_Blk_Length);
        this.DecodeInit(0, 42, Start_DataBlk_00, Start_Blk_Length);
        this.DecodeInit(0, 69, Start_DataBlk_01, Start_Blk_Length);
        this.DecodeInit(0, 42, Start_DataBlk_02, Start_Blk_Length);
        this.NbMax_DataBlk = 12000;
        this.datablk_item = new DataBlkAvg_Item[this.NbMax_DataBlk];
        for (int i = 0; i < this.NbMax_DataBlk; ++i) {
            this.datablk_item[i] = new DataBlkAvg_Item();
        }
        this.SetMaximumFramesNumber(this.NbMax_DataBlk);
        this.Nb_DataBlk = 0;
        this.DoItOnce = true;
    }

    @Override
    public void ReInitialize_SpecificParameters() {
        this.Nb_DataBlk = 0;
        this.DoItOnce = true;
        for (int i = 0; i < 8; ++i) {
            this.LastTemp[i] = 0.0f;
        }
    }

    @Override
    public String GetFileHeading() {
        String sep = "\t";
        this.Info.SetSeparator(sep);
        return "Time(s)" + sep + "RotRateXV1(\u00b0/h)" + sep + "RotRateXV2(\u00b0/h)" + sep + "RotRateXV3(\u00b0/h)" + sep + "AccXV1(m/s2)" + sep + "AccXV2(m/s2)" + sep + "AccXV3(m/s2)" + sep + "Status(Hexa)" + sep + "TempFogX1(\u00b0C)" + sep + "TempFogX2(\u00b0C)" + sep + "TempFogX3(\u00b0C)" + sep + "TempAccX1(\u00b0C)" + sep + "TempAccX2(\u00b0C)" + sep + "TempAccX3(\u00b0C)" + sep + "TempSrc(\u00b0C)" + sep + "TempAna(\u00b0C)";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        if (Length == 42) {
            this.ProcessDetectedFrame(Detected_Frame, 0, 42);
        } else if (Length == 69) {
            this.ProcessDetectedFrame(Detected_Frame, 0, 69);
        } else if (Length == 42) {
            this.ProcessDetectedFrame(Detected_Frame, 0, 42);
        } else if (Length == 29) {
            this.ProcessDetectedFrame(Detected_Frame, 0, 29);
        }
        return 0;
    }

    public int ProcessDetectedFrame(byte[] Detected_Frame, int BlocStart, int Nb) {
        if ((Detected_Frame[BlocStart + 1] & 0xF0) == 32) {
            this.DataBlock_version = Detected_Frame[BlocStart + 1] & 0xF;
            if (!this.IsChecksumValid(Detected_Frame, BlocStart, Nb)) {
                System.out.println("ERR0: Item DATA Block v" + this.DataBlock_version + " detected with Checksum err.");
                return 0;
            }
            if (this.Nb_DataBlk == this.NbMax_DataBlk && this.DoItOnce) {
                System.out.println("ERR1: The number of DATA Blocks v" + this.DataBlock_version + " stored before a KEY detection exceeds " + Integer.toString(this.NbMax_DataBlk));
                System.out.println("      Reset of the storage.");
                this.Nb_DataBlk = 0;
                return 0;
            }
            this.datablk_item[this.Nb_DataBlk++].DataBlk_Item_Set(Detected_Frame, BlocStart);
        } else if ((Detected_Frame[BlocStart + 1] & 0xF0) == 16) {
            this.KeyBlock_version = Detected_Frame[BlocStart + 1] & 0xF;
            if (!this.IsChecksumValid(Detected_Frame, BlocStart, Nb)) {
                System.out.println("ERR0: Item KEY Block v" + this.KeyBlock_version + " detected with Checksum err.");
                return 0;
            }
            this.Nb_DataBlk_Decoded = 0;
            this.DoItOnce = true;
            System.out.println("-----------------------------------");
            System.out.println("Item KEY Block v" + this.KeyBlock_version + " detected");
            System.out.println("Items DATA blocks v" + this.DataBlock_version + " stored [" + Integer.toString(this.Nb_DataBlk) + "]");
            int KeyBlk_KeyId = this.Convert_1Byte_to_UnsignedInt(Detected_Frame, BlocStart + 2, 1);
            long RotRateXv1_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 3, 1);
            long RotRateXv2_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 7, 1);
            long RotRateXv3_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 11, 1);
            long AccXv1_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 15, 1);
            long AccXv2_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 19, 1);
            long AccXv3_Key = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, BlocStart + 23, 1);
            for (int N = 0; N < this.Nb_DataBlk; ++N) {
                DataBlkAvg_Item BlkItem = this.datablk_item[N];
                if (KeyBlk_KeyId != BlkItem.KeyId) continue;
                ++this.Nb_DataBlk_Decoded;
                BlkItem.DataBlk_Item_SetLastMemTemp(this.LastTemp);
                BlkItem.DataBlk_Item_Decode(RotRateXv1_Key, RotRateXv2_Key, RotRateXv3_Key, AccXv1_Key, AccXv2_Key, AccXv3_Key);
                BlkItem.DataBlk_Item_GetLastMemTemp(this.LastTemp);
                this.InterpretedFrame = this.FormatDecodedLine(BlkItem);
                this.InterpretedFrame_AddToList(this.InterpretedFrame);
            }
            this.Nb_DataBlk -= this.Nb_DataBlk_Decoded;
            System.out.println("Decoded [" + Integer.toString(this.Nb_DataBlk_Decoded) + "] Not decoded [" + Integer.toString(this.Nb_DataBlk) + "]");
            if (this.Nb_DataBlk > 0) {
                System.out.println("Reset of the storage.");
            }
            System.out.println("-----------------------------------");
        }
        return 0;
    }

    private String FormatDecodedLine(DataBlkAvg_Item BlkItem) {
        String formatted_line = "";
        formatted_line = this.InterpretDouble(BlkItem.Time, 6) + this.InterpretFloat(BlkItem.RotRateXv1, 6) + this.InterpretFloat(BlkItem.RotRateXv2, 6) + this.InterpretFloat(BlkItem.RotRateXv3, 6) + this.InterpretFloat(BlkItem.AccXv1, 6) + this.InterpretFloat(BlkItem.AccXv2, 6) + this.InterpretFloat(BlkItem.AccXv3, 6) + this.InterpretIntegerAsHex((int)BlkItem.SensorSta1);
        for (int i = 0; i < 8; ++i) {
            formatted_line = formatted_line + this.InterpretFloat(BlkItem.TemperaturesMem[i]);
        }
        return formatted_line;
    }

    private boolean IsChecksumValid(byte[] Frame2, int BlocStart, int Nb) {
        int i;
        int signed_sum = 0;
        for (i = BlocStart; i < BlocStart + Nb - 2; ++i) {
            signed_sum += Frame2[i];
        }
        signed_sum &= 0xFFFF;
        int unsigned_sum = 0;
        for (i = BlocStart; i < BlocStart + Nb - 2; ++i) {
            unsigned_sum += Frame2[i];
            if (Frame2[i] >= 0) continue;
            unsigned_sum += 256;
        }
        int chk_read = this.Convert_2Bytes_to_UnsignedInt(Frame2, BlocStart + Nb - 2, 1);
        if (chk_read == signed_sum || chk_read == (unsigned_sum &= 0xFFFF)) {
            return true;
        }
        System.out.println("Checksum Read:" + Integer.toHexString(chk_read) + " VS Signed:" + Integer.toHexString(signed_sum) + " Unsigned:" + Integer.toHexString(unsigned_sum));
        return false;
    }
}

