/*
 * Decompiled with CFR 0.152.
 */
package Protocols;

import LoggerDecoder.Decoder;
import LoggerDecoder.Encoder;

public class XC_POSTPROINCSYS_Decoder
extends Decoder {
    private Encoder Encod;
    public static final int DATABLOCK_LENGTH = 101;
    public static final int STX = -91;
    public static final int VER = 0;
    private int LastCounter = 0;

    public XC_POSTPROINCSYS_Decoder(Encoder Encod) {
        this.Encod = Encod;
        this.SetCurvePlotImplementation(false);
        int Start_Blk_Length = 2;
        byte[] Start_Blk = new byte[Start_Blk_Length];
        Start_Blk[0] = -91;
        Start_Blk[1] = 0;
        this.DecodeInit(0, 101, Start_Blk, Start_Blk_Length);
    }

    @Override
    public String GetFileHeading() {
        String sep = "\t";
        this.Info.SetSeparator(sep);
        return "";
    }

    @Override
    public int InterpretFrame(byte[] Detected_Frame, int Length) {
        int endianness = 1;
        int Missed = 0;
        int index = 0;
        int Checksum = 0;
        if (Length == 101) {
            if (Detected_Frame[0] != -91) {
                this.InterpretedFrame = "ERR_STX: Unexpected start byte 0";
                return -1;
            }
            if (Detected_Frame[1] != 0) {
                this.InterpretedFrame = "ERR_VER: Unexpected start byte 1";
                return -1;
            }
        }
        for (index = 0; index < 101; ++index) {
            Checksum ^= Detected_Frame[index];
        }
        if (Checksum != Detected_Frame[101]) {
            this.InterpretedFrame = "ERR_CHK: Unexpected checksum";
            return -1;
        }
        this.InterpretedFrame = "";
        float Time = this.Convert_4Bytes_to_Float(Detected_Frame, 2, endianness);
        int Counter = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 6, endianness);
        if (this.LastCounter > 0) {
            ++this.LastCounter;
            if (Counter != this.LastCounter && Counter + 65536 != this.LastCounter) {
                Missed = Counter - this.LastCounter;
                if (Missed < 0) {
                    Missed += 65536;
                }
                System.out.println("MISSED:" + this.InterpretIntegerAsInt(Missed) + "\r\n");
            }
        }
        this.LastCounter = Counter;
        float FogIncX = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 8, endianness);
        float FogIncY = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 12, endianness);
        float FogIncZ = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 16, endianness);
        float AccIncX = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 20, endianness);
        float AccIncY = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 24, endianness);
        float AccIncZ = this.Convert_4Bytes_to_SignedInt(Detected_Frame, 28, endianness);
        float FogSysX = this.Convert_4Bytes_to_Float(Detected_Frame, 32, endianness);
        float FogSysY = this.Convert_4Bytes_to_Float(Detected_Frame, 36, endianness);
        float FogSysZ = this.Convert_4Bytes_to_Float(Detected_Frame, 40, endianness);
        float AccSysX = this.Convert_4Bytes_to_Float(Detected_Frame, 44, endianness);
        float AccSysY = this.Convert_4Bytes_to_Float(Detected_Frame, 48, endianness);
        float AccSysZ = this.Convert_4Bytes_to_Float(Detected_Frame, 52, endianness);
        float TempFogX = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 56, endianness);
        float TempFogY = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 58, endianness);
        float TempFogZ = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 60, endianness);
        float TempAccX = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 62, endianness);
        float TempAccY = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 64, endianness);
        float TempAccZ = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 66, endianness);
        float TempSrc = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 68, endianness);
        float TempAna = this.Convert_2Bytes_to_UnsignedInt(Detected_Frame, 70, endianness);
        long SensorStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 72, endianness);
        long SensorStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 76, endianness);
        long AlgoStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 80, endianness);
        long AlgoStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 84, endianness);
        long SystemStatus1 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 88, endianness);
        long SystemStatus2 = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 92, endianness);
        long UserStatus = this.Convert_4Bytes_to_UnsignedInt(Detected_Frame, 96, endianness);
        this.InterpretedFrame = this.InterpretedFrame + "INCSYS:" + this.InterpretIntegerAsInt(Counter);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogIncX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogIncY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogIncZ);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccIncX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccIncY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccIncZ) + "|\t";
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogSysX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogSysY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(FogSysZ);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccSysX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccSysY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(AccSysZ) + "|";
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempFogX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempFogY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempFogZ);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAccX);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAccY);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAccZ);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempSrc);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretFloat(TempAna) + "|";
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SensorStatus1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SensorStatus2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgoStatus1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)AlgoStatus2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SystemStatus1);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)SystemStatus2);
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretIntegerAsHex((int)UserStatus) + "|";
        this.InterpretedFrame = this.InterpretedFrame + this.InterpretDouble(Time);
        this.InterpretedFrame_AddToList(this.InterpretedFrame);
        return 0;
    }
}

