﻿using Moxa.Device.Scanning;
using Moxa.Device.TPEInformation;
using Newtonsoft.Json;
using System.Collections;
using System.Collections.Concurrent;
using System.Diagnostics;
using System.Net.WebSockets;
using System.Text;

namespace DeviceSearchUtility
{
    public class WebSocketHandler
    {
        private readonly ILogger logger;
        public static ConcurrentDictionary<int, WebSocket> WebSockets = new ConcurrentDictionary<int, WebSocket>();
        public static int lastIndex;

        public WebSocketHandler()
        {

        }

        public WebSocketHandler(ILogger<WebSocketHandler> logger)
        {
            this.logger = logger;
        }

        public static int GetWebSocketIdx()
        {
            return lastIndex;
        }

        public async Task ProcessWebSocket(WebSocket webSocket)
        {
            var buffer = new byte[1024 * 4];
            var wsdir = "temp";
            try
            {
                //Console.WriteLine("ProcessWebSocket");
                //Console.WriteLine("webSocket.GetHashCode() = " + webSocket.GetHashCode());
                WebSockets.TryAdd(webSocket.GetHashCode(), webSocket);
                lastIndex = webSocket.GetHashCode();
                DsScanDeviceBehavior._webSocketCallback = GetWebSocketIdx;
                
                var res = await webSocket.ReceiveAsync(new ArraySegment<byte>(buffer), CancellationToken.None);

                while (!res.CloseStatus.HasValue)
                {
                    Console.WriteLine("ProcessWebSocket loop start");
                    var cmd = Encoding.UTF8.GetString(buffer, 0, res.Count);

                    Console.WriteLine(cmd);

                    Console.WriteLine("ProcessWebSocket loop await receiveAsync");
                    res = await webSocket.ReceiveAsync(new ArraySegment<byte>(buffer), CancellationToken.None);
                    Console.WriteLine("ProcessWebSocket loop end, receiveAsync");
                }
                //Console.WriteLine("ProcessWebSocket await CloseAsync");
                await webSocket.CloseAsync(res.CloseStatus.Value, res.CloseStatusDescription, CancellationToken.None);
                DsScanDeviceBehavior._webSocketCallback = null;
                WebSockets.TryRemove(webSocket.GetHashCode(), out var removed);
                //Broadcast($"{webSocket.GetHashCode()} closed the WebSocket connection.");
                WSClose($"{webSocket.GetHashCode()} closed the WebSocket connection.");
                //Console.WriteLine($"webSocket disconnect: {webSocket.GetHashCode()}");
                if (WebSockets.Count == 0)
                {
                    // clear all device information
                    DsList.OneInfoList.Clear();
                    DsFindDevice.StopFindDevice();
                }
            }
            catch (WebSocketException ex)
            {
                if (ex.Message.Contains("The remote party closed the WebSocket connection without completing the close handshake."))
                {
                    Console.WriteLine("WebSocket connection closed unexpectedly by the remote party.");                    
                }
                else
                {
                    Console.WriteLine("WebSocketException: " + ex.Message);                    
                }                
                webSocket.Dispose();
                DsScanDeviceBehavior._webSocketCallback = null;
                WebSockets.TryRemove(webSocket.GetHashCode(), out var removed);
                WSClose($"{webSocket.GetHashCode()} WebSocket connection closed unexpectedly.");
                //Console.WriteLine($"webSocket disconnect: {webSocket.GetHashCode()}");
            }
            catch (Exception ex)
            {
                Console.WriteLine("Exception: " + ex.Message);
                webSocket.Dispose(); 
                DsScanDeviceBehavior._webSocketCallback = null;
                WebSockets.TryRemove(webSocket.GetHashCode(), out var removed);
                WSClose($"{webSocket.GetHashCode()} WebSocket connection closed unexpectedly due to" + ex.Message);
                //Console.WriteLine($"webSocket disconnect: {webSocket.GetHashCode()}");
            }
        }

        public void Uincast(string message, int idx)
        {
            var buff = Encoding.UTF8.GetBytes(message);
            var data = new ArraySegment<byte>(buff, 0, buff.Length);
            Parallel.ForEach(WebSockets.Values, async (webSocket) =>
            {
                if (webSocket.State == WebSocketState.Open && idx == webSocket.GetHashCode())
                {
                    await webSocket.SendAsync(data, WebSocketMessageType.Text, true, CancellationToken.None);
                }
            });
        }

        public void Broadcast(string message)
        {
            //Console.WriteLine("Broadcast" + message);            
            var buff = Encoding.UTF8.GetBytes(message);
            var data = new ArraySegment<byte>(buff, 0, buff.Length);
            Parallel.ForEach(WebSockets.Values, async (webSocket) =>
            {
                if (webSocket.State == WebSocketState.Open)
                {
                    await webSocket.SendAsync(data, WebSocketMessageType.Text, true, CancellationToken.None);
                }
            });
        }

        public void WSClose(string message)
        {    
            WebSocketHandler wsh = new WebSocketHandler();

            Hashtable hsWebSocket = new Hashtable();
            hsWebSocket["message"] = message;            

            string msg = "";
            msg = JsonConvert.SerializeObject(hsWebSocket);

            wsh.Broadcast(msg);
        }

        public class ResponseWebSocket
        {
            public ResponseWebSocketData data { get; set; }
        }

        public class ResponseWebSocketData
        {
            public string Message { get; set; }
        }
    }
}
